/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

abstract class FloatArrayBuffer
extends FloatBuffer {
    protected final float[] backingArray;
    protected final int offset;

    FloatArrayBuffer(float[] array) {
        this(array.length, array, 0);
    }

    FloatArrayBuffer(int capacity) {
        this(capacity, new float[capacity], 0);
    }

    FloatArrayBuffer(int capacity, float[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    public final float get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    public final float get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.offset + index];
    }

    public final FloatBuffer get(float[] dst, int dstOffset, int floatCount) {
        if (floatCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dst, dstOffset, floatCount);
        this.position += floatCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

