/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.ReadWriteFloatArrayBuffer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FloatBuffer
extends Buffer
implements Comparable<FloatBuffer> {
    public static FloatBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return new ReadWriteFloatArrayBuffer(capacity);
    }

    public static FloatBuffer wrap(float[] array) {
        return FloatBuffer.wrap(array, 0, array.length);
    }

    public static FloatBuffer wrap(float[] array, int start, int floatCount) {
        Arrays.checkOffsetAndCount(array.length, start, floatCount);
        ReadWriteFloatArrayBuffer buf = new ReadWriteFloatArrayBuffer(array);
        buf.position = start;
        buf.limit = start + floatCount;
        return buf;
    }

    FloatBuffer(int capacity) {
        super(2, capacity, null);
    }

    public final float[] array() {
        return this.protectedArray();
    }

    @Override
    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract FloatBuffer asReadOnlyBuffer();

    public abstract FloatBuffer compact();

    @Override
    public int compareTo(FloatBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            float otherFloat;
            float thisFloat = this.get(thisPos);
            if (thisFloat != (otherFloat = otherBuffer.get(otherPos)) && (thisFloat == thisFloat || otherFloat == otherFloat)) {
                return thisFloat < otherFloat ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract FloatBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer otherBuffer = (FloatBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            float b;
            float a;
            equalSoFar = (a = this.get(myPosition++)) == (b = otherBuffer.get(otherPosition++)) || a != a && b != b;
        }
        return equalSoFar;
    }

    public abstract float get();

    public FloatBuffer get(float[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public FloatBuffer get(float[] dst, int dstOffset, int floatCount) {
        Arrays.checkOffsetAndCount(dst.length, dstOffset, floatCount);
        if (floatCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = dstOffset; i < dstOffset + floatCount; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public abstract float get(int var1);

    @Override
    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += Float.floatToIntBits(this.get(myPosition++));
        }
        return hash;
    }

    @Override
    public abstract boolean isDirect();

    public abstract ByteOrder order();

    abstract float[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract FloatBuffer put(float var1);

    public final FloatBuffer put(float[] src) {
        return this.put(src, 0, src.length);
    }

    public FloatBuffer put(float[] src, int srcOffset, int floatCount) {
        Arrays.checkOffsetAndCount(src.length, srcOffset, floatCount);
        if (floatCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = srcOffset; i < srcOffset + floatCount; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public FloatBuffer put(FloatBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        float[] contents = new float[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer slice();
}

