/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BaseByteBuffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import libcore.io.Memory;

abstract class HeapByteBuffer
extends BaseByteBuffer {
    final byte[] backingArray;
    final int offset;

    HeapByteBuffer(byte[] backingArray) {
        this(backingArray, backingArray.length, 0);
    }

    HeapByteBuffer(int capacity) {
        this(new byte[capacity], capacity, 0);
    }

    HeapByteBuffer(byte[] backingArray, int capacity, int offset) {
        super(capacity, null);
        this.backingArray = backingArray;
        this.offset = offset;
        if (offset + capacity > backingArray.length) {
            throw new IndexOutOfBoundsException("backingArray.length=" + backingArray.length + ", capacity=" + capacity + ", offset=" + offset);
        }
    }

    public final ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        this.checkGetBounds(1, dst.length, dstOffset, byteCount);
        System.arraycopy(this.backingArray, this.offset + this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    final void get(char[] dst, int dstOffset, int charCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, charCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.offset + this.position, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(double[] dst, int dstOffset, int doubleCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, doubleCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.offset + this.position, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(float[] dst, int dstOffset, int floatCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, floatCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.offset + this.position, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(int[] dst, int dstOffset, int intCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, intCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.offset + this.position, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(long[] dst, int dstOffset, int longCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, longCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.offset + this.position, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(short[] dst, int dstOffset, int shortCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, shortCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.offset + this.position, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    public final byte get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    public final byte get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.offset + index];
    }

    public final char getChar() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        char result = (char)Memory.peekShort(this.backingArray, this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final char getChar(int index) {
        this.checkIndex(index, 2);
        return (char)Memory.peekShort(this.backingArray, this.offset + index, this.order);
    }

    public final double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final int getInt() {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        int result = Memory.peekInt(this.backingArray, this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final int getInt(int index) {
        this.checkIndex(index, 4);
        return Memory.peekInt(this.backingArray, this.offset + index, this.order);
    }

    public final long getLong() {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        long result = Memory.peekLong(this.backingArray, this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final long getLong(int index) {
        this.checkIndex(index, 8);
        return Memory.peekLong(this.backingArray, this.offset + index, this.order);
    }

    public final short getShort() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        short result = Memory.peekShort(this.backingArray, this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final short getShort(int index) {
        this.checkIndex(index, 2);
        return Memory.peekShort(this.backingArray, this.offset + index, this.order);
    }

    public final boolean isDirect() {
        return false;
    }
}

