/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

abstract class IntArrayBuffer
extends IntBuffer {
    protected final int[] backingArray;
    protected final int offset;

    IntArrayBuffer(int[] array) {
        this(array.length, array, 0);
    }

    IntArrayBuffer(int capacity) {
        this(capacity, new int[capacity], 0);
    }

    IntArrayBuffer(int capacity, int[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    public final int get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    public final int get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.offset + index];
    }

    public final IntBuffer get(int[] dst, int dstOffset, int intCount) {
        if (intCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dst, dstOffset, intCount);
        this.position += intCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

