/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

abstract class LongArrayBuffer
extends LongBuffer {
    protected final long[] backingArray;
    protected final int offset;

    LongArrayBuffer(long[] array) {
        this(array.length, array, 0);
    }

    LongArrayBuffer(int capacity) {
        this(capacity, new long[capacity], 0);
    }

    LongArrayBuffer(int capacity, long[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    public final long get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    public final long get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.offset + index];
    }

    public final LongBuffer get(long[] dst, int dstOffset, int longCount) {
        if (longCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dst, dstOffset, longCount);
        this.position += longCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

