/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.MemoryBlock;
import java.nio.ReadOnlyDirectByteBuffer;
import java.nio.ReadWriteDirectByteBuffer;
import java.nio.channels.FileChannel;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;

public abstract class MappedByteBuffer
extends ByteBuffer {
    final DirectByteBuffer wrapped;
    private final FileChannel.MapMode mapMode;

    MappedByteBuffer(ByteBuffer directBuffer) {
        super(directBuffer.capacity, directBuffer.block);
        if (!directBuffer.isDirect()) {
            throw new IllegalArgumentException();
        }
        this.wrapped = (DirectByteBuffer)directBuffer;
        this.mapMode = null;
    }

    MappedByteBuffer(MemoryBlock block, int capacity, int offset, FileChannel.MapMode mapMode) {
        super(capacity, block);
        this.mapMode = mapMode;
        this.wrapped = mapMode == FileChannel.MapMode.READ_ONLY ? new ReadOnlyDirectByteBuffer(block, capacity, offset) : new ReadWriteDirectByteBuffer(block, capacity, offset);
    }

    public final boolean isLoaded() {
        long address = this.block.toInt();
        long size = this.block.getSize();
        if (size == 0L) {
            return true;
        }
        try {
            int pageSize = (int)Libcore.os.sysconf(OsConstants._SC_PAGE_SIZE);
            int pageOffset = (int)(address % (long)pageSize);
            int pageCount = (int)(((size += (long)pageOffset) + (long)pageSize - 1L) / (long)pageSize);
            byte[] vector = new byte[pageCount];
            Libcore.os.mincore(address -= (long)pageOffset, size, vector);
            for (int i = 0; i < vector.length; ++i) {
                if ((vector[i] & 1) == 1) continue;
                return false;
            }
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public final MappedByteBuffer load() {
        try {
            Libcore.os.mlock(this.block.toInt(), this.block.getSize());
            Libcore.os.munlock(this.block.toInt(), this.block.getSize());
        }
        catch (ErrnoException errnoException) {
            // empty catch block
        }
        return this;
    }

    public final MappedByteBuffer force() {
        if (this.mapMode == FileChannel.MapMode.READ_WRITE) {
            try {
                Libcore.os.msync(this.block.toInt(), this.block.getSize(), OsConstants.MS_SYNC);
            }
            catch (ErrnoException errnoException) {
                throw new AssertionError((Object)errnoException);
            }
        }
        return this;
    }
}

