/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.FileDescriptor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.HeapByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.MappedByteBufferAdapter;
import java.nio.channels.FileChannel;

public final class NioUtils {
    private NioUtils() {
    }

    public static int getDirectBufferAddress(Buffer buffer) {
        return buffer.effectiveDirectAddress;
    }

    public static void freeDirectBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer instanceof DirectByteBuffer) {
            ((DirectByteBuffer)buffer).free();
        } else if (buffer instanceof MappedByteBuffer) {
            ((MappedByteBufferAdapter)buffer).free();
        } else {
            throw new AssertionError();
        }
    }

    public static FileDescriptor getFD(FileChannel fc) {
        return ((FileChannelImpl)fc).getFD();
    }

    public static FileChannel newFileChannel(Object stream, FileDescriptor fd, int mode) {
        return new FileChannelImpl(stream, fd, mode);
    }

    public static byte[] unsafeArray(ByteBuffer b) {
        return ((HeapByteBuffer)b).backingArray;
    }

    public static int unsafeArrayOffset(ByteBuffer b) {
        return ((HeapByteBuffer)b).offset;
    }
}

