/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FileDescriptorChannel;
import java.nio.NioUtils;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import libcore.io.ErrnoException;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;

final class PipeImpl
extends Pipe {
    private final PipeSinkChannel sink;
    private final PipeSourceChannel source;

    public PipeImpl() throws IOException {
        try {
            FileDescriptor[] fds = Libcore.os.pipe();
            this.sink = new PipeSinkChannel(fds[1]);
            this.source = new PipeSourceChannel(fds[0]);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    private class PipeSinkChannel
    extends Pipe.SinkChannel
    implements FileDescriptorChannel {
        private final FileDescriptor fd;
        private final FileChannel channel;

        private PipeSinkChannel(FileDescriptor fd) throws IOException {
            super(SelectorProvider.provider());
            this.fd = fd;
            this.channel = NioUtils.newFileChannel(new FdCloser(fd), fd, OsConstants.O_WRONLY);
        }

        protected void implCloseSelectableChannel() throws IOException {
            this.channel.close();
        }

        protected void implConfigureBlocking(boolean blocking) throws IOException {
            IoUtils.setBlocking(this.getFD(), blocking);
        }

        public int write(ByteBuffer buffer) throws IOException {
            return this.channel.write(buffer);
        }

        public long write(ByteBuffer[] buffers) throws IOException {
            return this.channel.write(buffers);
        }

        public long write(ByteBuffer[] buffers, int offset, int length) throws IOException {
            return this.channel.write(buffers, offset, length);
        }

        public FileDescriptor getFD() {
            return this.fd;
        }
    }

    private class PipeSourceChannel
    extends Pipe.SourceChannel
    implements FileDescriptorChannel {
        private final FileDescriptor fd;
        private final FileChannel channel;

        private PipeSourceChannel(FileDescriptor fd) throws IOException {
            super(SelectorProvider.provider());
            this.fd = fd;
            this.channel = NioUtils.newFileChannel(new FdCloser(fd), fd, OsConstants.O_RDONLY);
        }

        protected void implCloseSelectableChannel() throws IOException {
            this.channel.close();
        }

        protected void implConfigureBlocking(boolean blocking) throws IOException {
            IoUtils.setBlocking(this.getFD(), blocking);
        }

        public int read(ByteBuffer buffer) throws IOException {
            return this.channel.read(buffer);
        }

        public long read(ByteBuffer[] buffers) throws IOException {
            return this.channel.read(buffers);
        }

        public long read(ByteBuffer[] buffers, int offset, int length) throws IOException {
            return this.channel.read(buffers, offset, length);
        }

        public FileDescriptor getFD() {
            return this.fd;
        }
    }

    private static class FdCloser
    implements Closeable {
        private final FileDescriptor fd;

        private FdCloser(FileDescriptor fd) {
            this.fd = fd;
        }

        public void close() throws IOException {
            IoUtils.close(this.fd);
        }
    }
}

