/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.CharArrayBuffer;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class ReadOnlyCharArrayBuffer
extends CharArrayBuffer {
    static ReadOnlyCharArrayBuffer copy(CharArrayBuffer other, int markOfOther) {
        ReadOnlyCharArrayBuffer buf = new ReadOnlyCharArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadOnlyCharArrayBuffer(int capacity, char[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer duplicate() {
        return ReadOnlyCharArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected char[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public CharBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer put(int index, char c) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer put(char[] src, int srcOffset, int charCount) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer put(CharBuffer src) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer put(String src, int start, int end) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer slice() {
        return new ReadOnlyCharArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

