/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.MemoryBlock;
import java.nio.ReadOnlyBufferException;

final class ReadOnlyDirectByteBuffer
extends DirectByteBuffer {
    static ReadOnlyDirectByteBuffer copy(DirectByteBuffer other, int markOfOther) {
        ReadOnlyDirectByteBuffer buf = new ReadOnlyDirectByteBuffer(other.block, other.capacity(), other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    protected ReadOnlyDirectByteBuffer(MemoryBlock block, int capacity, int offset) {
        super(block, capacity, offset);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return ReadOnlyDirectByteBuffer.copy(this, this.mark);
    }

    public ByteBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer duplicate() {
        return ReadOnlyDirectByteBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    public ByteBuffer put(byte value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(int index, byte value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(double value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(int index, double value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(float value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(int index, float value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(long value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(int index, short value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(short value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(ByteBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer slice() {
        return new ReadOnlyDirectByteBuffer(this.block, this.remaining(), this.offset + this.position);
    }

    protected byte[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }
}

