/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.DoubleArrayBuffer;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyBufferException;

final class ReadOnlyDoubleArrayBuffer
extends DoubleArrayBuffer {
    static ReadOnlyDoubleArrayBuffer copy(DoubleArrayBuffer other, int markOfOther) {
        ReadOnlyDoubleArrayBuffer buf = new ReadOnlyDoubleArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadOnlyDoubleArrayBuffer(int capacity, double[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public DoubleBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public DoubleBuffer duplicate() {
        return ReadOnlyDoubleArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected double[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public DoubleBuffer put(double c) {
        throw new ReadOnlyBufferException();
    }

    public DoubleBuffer put(int index, double c) {
        throw new ReadOnlyBufferException();
    }

    public final DoubleBuffer put(double[] src, int srcOffset, int byteCount) {
        throw new ReadOnlyBufferException();
    }

    public final DoubleBuffer put(DoubleBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    public DoubleBuffer slice() {
        return new ReadOnlyDoubleArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

