/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.FloatArrayBuffer;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;

final class ReadOnlyFloatArrayBuffer
extends FloatArrayBuffer {
    static ReadOnlyFloatArrayBuffer copy(FloatArrayBuffer other, int markOfOther) {
        ReadOnlyFloatArrayBuffer buf = new ReadOnlyFloatArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadOnlyFloatArrayBuffer(int capacity, float[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public FloatBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer duplicate() {
        return ReadOnlyFloatArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected float[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public FloatBuffer put(float c) {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer put(int index, float c) {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer put(FloatBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    public final FloatBuffer put(float[] src, int srcOffset, int byteCount) {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer slice() {
        return new ReadOnlyFloatArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

