/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.HeapByteBuffer;
import java.nio.ReadOnlyBufferException;

final class ReadOnlyHeapByteBuffer
extends HeapByteBuffer {
    static ReadOnlyHeapByteBuffer copy(HeapByteBuffer other, int markOfOther) {
        ReadOnlyHeapByteBuffer buf = new ReadOnlyHeapByteBuffer(other.backingArray, other.capacity(), other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadOnlyHeapByteBuffer(byte[] backingArray, int capacity, int arrayOffset) {
        super(backingArray, capacity, arrayOffset);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return ReadOnlyHeapByteBuffer.copy(this, this.mark);
    }

    public ByteBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer duplicate() {
        return ReadOnlyHeapByteBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected byte[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public ByteBuffer put(byte b) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(int index, byte b) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(double value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(int index, double value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(float value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(int index, float value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(long value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(int index, short value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(short value) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(ByteBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer slice() {
        return new ReadOnlyHeapByteBuffer(this.backingArray, this.remaining(), this.offset + this.position);
    }
}

