/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.IntArrayBuffer;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

final class ReadOnlyIntArrayBuffer
extends IntArrayBuffer {
    static ReadOnlyIntArrayBuffer copy(IntArrayBuffer other, int markOfOther) {
        ReadOnlyIntArrayBuffer buf = new ReadOnlyIntArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadOnlyIntArrayBuffer(int capacity, int[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public IntBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public IntBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public IntBuffer duplicate() {
        return ReadOnlyIntArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected int[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public IntBuffer put(int c) {
        throw new ReadOnlyBufferException();
    }

    public IntBuffer put(int index, int c) {
        throw new ReadOnlyBufferException();
    }

    public IntBuffer put(IntBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    public final IntBuffer put(int[] src, int srcOffset, int intCount) {
        throw new ReadOnlyBufferException();
    }

    public IntBuffer slice() {
        return new ReadOnlyIntArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

