/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.LongArrayBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

final class ReadOnlyLongArrayBuffer
extends LongArrayBuffer {
    static ReadOnlyLongArrayBuffer copy(LongArrayBuffer other, int markOfOther) {
        ReadOnlyLongArrayBuffer buf = new ReadOnlyLongArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadOnlyLongArrayBuffer(int capacity, long[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public LongBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public LongBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer duplicate() {
        return ReadOnlyLongArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected long[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public LongBuffer put(long c) {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer put(int index, long c) {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer put(LongBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    public final LongBuffer put(long[] src, int srcOffset, int longCount) {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer slice() {
        return new ReadOnlyLongArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

