/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ReadOnlyBufferException;
import java.nio.ShortArrayBuffer;
import java.nio.ShortBuffer;

final class ReadOnlyShortArrayBuffer
extends ShortArrayBuffer {
    static ReadOnlyShortArrayBuffer copy(ShortArrayBuffer other, int markOfOther) {
        ReadOnlyShortArrayBuffer buf = new ReadOnlyShortArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadOnlyShortArrayBuffer(int capacity, short[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public ShortBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer duplicate() {
        return ReadOnlyShortArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return true;
    }

    protected short[] protectedArray() {
        throw new ReadOnlyBufferException();
    }

    protected int protectedArrayOffset() {
        throw new ReadOnlyBufferException();
    }

    protected boolean protectedHasArray() {
        return false;
    }

    public ShortBuffer put(ShortBuffer buf) {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer put(short c) {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer put(int index, short c) {
        throw new ReadOnlyBufferException();
    }

    public final ShortBuffer put(short[] src, int srcOffset, int shortCount) {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer slice() {
        return new ReadOnlyShortArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

