/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.CharArrayBuffer;
import java.nio.CharBuffer;
import java.nio.ReadOnlyCharArrayBuffer;

final class ReadWriteCharArrayBuffer
extends CharArrayBuffer {
    static ReadWriteCharArrayBuffer copy(CharArrayBuffer other, int markOfOther) {
        ReadWriteCharArrayBuffer buf = new ReadWriteCharArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteCharArrayBuffer(char[] array) {
        super(array);
    }

    ReadWriteCharArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteCharArrayBuffer(int capacity, char[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public CharBuffer asReadOnlyBuffer() {
        return ReadOnlyCharArrayBuffer.copy(this, this.mark);
    }

    public CharBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public CharBuffer duplicate() {
        return ReadWriteCharArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected char[] protectedArray() {
        return this.backingArray;
    }

    protected int protectedArrayOffset() {
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return true;
    }

    public CharBuffer put(char c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    public CharBuffer put(int index, char c) {
        this.checkIndex(index);
        this.backingArray[this.offset + index] = c;
        return this;
    }

    public CharBuffer put(char[] src, int srcOffset, int charCount) {
        if (charCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.offset + this.position, charCount);
        this.position += charCount;
        return this;
    }

    public CharBuffer slice() {
        return new ReadWriteCharArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

