/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.MemoryBlock;
import java.nio.ReadOnlyDirectByteBuffer;
import libcore.io.Memory;

final class ReadWriteDirectByteBuffer
extends DirectByteBuffer {
    static ReadWriteDirectByteBuffer copy(DirectByteBuffer other, int markOfOther) {
        ReadWriteDirectByteBuffer buf = new ReadWriteDirectByteBuffer(other.block, other.capacity(), other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteDirectByteBuffer(int capacity) {
        super(MemoryBlock.allocate(capacity), capacity, 0);
    }

    ReadWriteDirectByteBuffer(int address, int capacity) {
        super(MemoryBlock.wrapFromJni(address, capacity), capacity, 0);
    }

    ReadWriteDirectByteBuffer(MemoryBlock block, int capacity, int offset) {
        super(block, capacity, offset);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return ReadOnlyDirectByteBuffer.copy(this, this.mark);
    }

    public ByteBuffer compact() {
        Memory.memmove(this, 0, this, this.position, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public ByteBuffer duplicate() {
        return ReadWriteDirectByteBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteBuffer put(byte value) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeByte(this.offset + this.position++, value);
        return this;
    }

    public ByteBuffer put(int index, byte value) {
        this.checkIndex(index);
        this.block.pokeByte(this.offset + index, value);
        return this;
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        this.checkPutBounds(1, src.length, srcOffset, byteCount);
        this.block.pokeByteArray(this.offset + this.position, src, srcOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    final void put(char[] src, int srcOffset, int charCount) {
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, charCount);
        this.block.pokeCharArray(this.offset + this.position, src, srcOffset, charCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(double[] src, int srcOffset, int doubleCount) {
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, doubleCount);
        this.block.pokeDoubleArray(this.offset + this.position, src, srcOffset, doubleCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(float[] src, int srcOffset, int floatCount) {
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, floatCount);
        this.block.pokeFloatArray(this.offset + this.position, src, srcOffset, floatCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(int[] src, int srcOffset, int intCount) {
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, intCount);
        this.block.pokeIntArray(this.offset + this.position, src, srcOffset, intCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(long[] src, int srcOffset, int longCount) {
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, longCount);
        this.block.pokeLongArray(this.offset + this.position, src, srcOffset, longCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(short[] src, int srcOffset, int shortCount) {
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, shortCount);
        this.block.pokeShortArray(this.offset + this.position, src, srcOffset, shortCount, this.order.needsSwap);
        this.position += byteCount;
    }

    public ByteBuffer putChar(char value) {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeShort(this.offset + this.position, (short)value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putChar(int index, char value) {
        this.checkIndex(index, 2);
        this.block.pokeShort(this.offset + index, (short)value, this.order);
        return this;
    }

    public ByteBuffer putDouble(double value) {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeLong(this.offset + this.position, Double.doubleToRawLongBits(value), this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putDouble(int index, double value) {
        this.checkIndex(index, 8);
        this.block.pokeLong(this.offset + index, Double.doubleToRawLongBits(value), this.order);
        return this;
    }

    public ByteBuffer putFloat(float value) {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeInt(this.offset + this.position, Float.floatToRawIntBits(value), this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putFloat(int index, float value) {
        this.checkIndex(index, 4);
        this.block.pokeInt(this.offset + index, Float.floatToRawIntBits(value), this.order);
        return this;
    }

    public ByteBuffer putInt(int value) {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeInt(this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putInt(int index, int value) {
        this.checkIndex(index, 4);
        this.block.pokeInt(this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer putLong(long value) {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeLong(this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putLong(int index, long value) {
        this.checkIndex(index, 8);
        this.block.pokeLong(this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer putShort(short value) {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeShort(this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putShort(int index, short value) {
        this.checkIndex(index, 2);
        this.block.pokeShort(this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer slice() {
        return new ReadWriteDirectByteBuffer(this.block, this.remaining(), this.offset + this.position);
    }
}

