/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.DoubleArrayBuffer;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyDoubleArrayBuffer;

final class ReadWriteDoubleArrayBuffer
extends DoubleArrayBuffer {
    static ReadWriteDoubleArrayBuffer copy(DoubleArrayBuffer other, int markOfOther) {
        ReadWriteDoubleArrayBuffer buf = new ReadWriteDoubleArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteDoubleArrayBuffer(double[] array) {
        super(array);
    }

    ReadWriteDoubleArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteDoubleArrayBuffer(int capacity, double[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return ReadOnlyDoubleArrayBuffer.copy(this, this.mark);
    }

    public DoubleBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public DoubleBuffer duplicate() {
        return ReadWriteDoubleArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected double[] protectedArray() {
        return this.backingArray;
    }

    protected int protectedArrayOffset() {
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return true;
    }

    public DoubleBuffer put(double c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    public DoubleBuffer put(int index, double c) {
        this.checkIndex(index);
        this.backingArray[this.offset + index] = c;
        return this;
    }

    public DoubleBuffer put(double[] src, int srcOffset, int doubleCount) {
        if (doubleCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.offset + this.position, doubleCount);
        this.position += doubleCount;
        return this;
    }

    public DoubleBuffer slice() {
        return new ReadWriteDoubleArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

