/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.FloatArrayBuffer;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyFloatArrayBuffer;

final class ReadWriteFloatArrayBuffer
extends FloatArrayBuffer {
    static ReadWriteFloatArrayBuffer copy(FloatArrayBuffer other, int markOfOther) {
        ReadWriteFloatArrayBuffer buf = new ReadWriteFloatArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteFloatArrayBuffer(float[] array) {
        super(array);
    }

    ReadWriteFloatArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteFloatArrayBuffer(int capacity, float[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public FloatBuffer asReadOnlyBuffer() {
        return ReadOnlyFloatArrayBuffer.copy(this, this.mark);
    }

    public FloatBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public FloatBuffer duplicate() {
        return ReadWriteFloatArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected float[] protectedArray() {
        return this.backingArray;
    }

    protected int protectedArrayOffset() {
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return true;
    }

    public FloatBuffer put(float c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    public FloatBuffer put(int index, float c) {
        this.checkIndex(index);
        this.backingArray[this.offset + index] = c;
        return this;
    }

    public FloatBuffer put(float[] src, int srcOffset, int floatCount) {
        if (floatCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.offset + this.position, floatCount);
        this.position += floatCount;
        return this;
    }

    public FloatBuffer slice() {
        return new ReadWriteFloatArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

