/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.HeapByteBuffer;
import java.nio.ReadOnlyHeapByteBuffer;
import libcore.io.Memory;

final class ReadWriteHeapByteBuffer
extends HeapByteBuffer {
    static ReadWriteHeapByteBuffer copy(HeapByteBuffer other, int markOfOther) {
        ReadWriteHeapByteBuffer buf = new ReadWriteHeapByteBuffer(other.backingArray, other.capacity(), other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteHeapByteBuffer(byte[] backingArray) {
        super(backingArray);
    }

    ReadWriteHeapByteBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteHeapByteBuffer(byte[] backingArray, int capacity, int arrayOffset) {
        super(backingArray, capacity, arrayOffset);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return ReadOnlyHeapByteBuffer.copy(this, this.mark);
    }

    public ByteBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public ByteBuffer duplicate() {
        return ReadWriteHeapByteBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected byte[] protectedArray() {
        return this.backingArray;
    }

    protected int protectedArrayOffset() {
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return true;
    }

    public ByteBuffer put(byte b) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = b;
        return this;
    }

    public ByteBuffer put(int index, byte b) {
        this.checkIndex(index);
        this.backingArray[this.offset + index] = b;
        return this;
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        this.checkPutBounds(1, src.length, srcOffset, byteCount);
        System.arraycopy(src, srcOffset, this.backingArray, this.offset + this.position, byteCount);
        this.position += byteCount;
        return this;
    }

    final void put(char[] src, int srcOffset, int charCount) {
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, charCount);
        Memory.unsafeBulkPut(this.backingArray, this.offset + this.position, byteCount, src, srcOffset, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(double[] src, int srcOffset, int doubleCount) {
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, doubleCount);
        Memory.unsafeBulkPut(this.backingArray, this.offset + this.position, byteCount, src, srcOffset, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(float[] src, int srcOffset, int floatCount) {
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, floatCount);
        Memory.unsafeBulkPut(this.backingArray, this.offset + this.position, byteCount, src, srcOffset, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(int[] src, int srcOffset, int intCount) {
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, intCount);
        Memory.unsafeBulkPut(this.backingArray, this.offset + this.position, byteCount, src, srcOffset, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(long[] src, int srcOffset, int longCount) {
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, longCount);
        Memory.unsafeBulkPut(this.backingArray, this.offset + this.position, byteCount, src, srcOffset, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(short[] src, int srcOffset, int shortCount) {
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, shortCount);
        Memory.unsafeBulkPut(this.backingArray, this.offset + this.position, byteCount, src, srcOffset, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    public ByteBuffer putChar(int index, char value) {
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.offset + index, (short)value, this.order);
        return this;
    }

    public ByteBuffer putChar(char value) {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeShort(this.backingArray, this.offset + this.position, (short)value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putDouble(double value) {
        return this.putLong(Double.doubleToRawLongBits(value));
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.putLong(index, Double.doubleToRawLongBits(value));
    }

    public ByteBuffer putFloat(float value) {
        return this.putInt(Float.floatToRawIntBits(value));
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.putInt(index, Float.floatToRawIntBits(value));
    }

    public ByteBuffer putInt(int value) {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeInt(this.backingArray, this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putInt(int index, int value) {
        this.checkIndex(index, 4);
        Memory.pokeInt(this.backingArray, this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer putLong(int index, long value) {
        this.checkIndex(index, 8);
        Memory.pokeLong(this.backingArray, this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer putLong(long value) {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeLong(this.backingArray, this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putShort(int index, short value) {
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer putShort(short value) {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeShort(this.backingArray, this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer slice() {
        return new ReadWriteHeapByteBuffer(this.backingArray, this.remaining(), this.offset + this.position);
    }
}

