/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.IntArrayBuffer;
import java.nio.IntBuffer;
import java.nio.ReadOnlyIntArrayBuffer;

final class ReadWriteIntArrayBuffer
extends IntArrayBuffer {
    static ReadWriteIntArrayBuffer copy(IntArrayBuffer other, int markOfOther) {
        ReadWriteIntArrayBuffer buf = new ReadWriteIntArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteIntArrayBuffer(int[] array) {
        super(array);
    }

    ReadWriteIntArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteIntArrayBuffer(int capacity, int[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public IntBuffer asReadOnlyBuffer() {
        return ReadOnlyIntArrayBuffer.copy(this, this.mark);
    }

    public IntBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public IntBuffer duplicate() {
        return ReadWriteIntArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected int[] protectedArray() {
        return this.backingArray;
    }

    protected int protectedArrayOffset() {
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return true;
    }

    public IntBuffer put(int c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    public IntBuffer put(int index, int c) {
        this.checkIndex(index);
        this.backingArray[this.offset + index] = c;
        return this;
    }

    public IntBuffer put(int[] src, int srcOffset, int intCount) {
        if (intCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.offset + this.position, intCount);
        this.position += intCount;
        return this;
    }

    public IntBuffer slice() {
        return new ReadWriteIntArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

