/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.LongArrayBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyLongArrayBuffer;

final class ReadWriteLongArrayBuffer
extends LongArrayBuffer {
    static ReadWriteLongArrayBuffer copy(LongArrayBuffer other, int markOfOther) {
        ReadWriteLongArrayBuffer buf = new ReadWriteLongArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteLongArrayBuffer(long[] array) {
        super(array);
    }

    ReadWriteLongArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteLongArrayBuffer(int capacity, long[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public LongBuffer asReadOnlyBuffer() {
        return ReadOnlyLongArrayBuffer.copy(this, this.mark);
    }

    public LongBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public LongBuffer duplicate() {
        return ReadWriteLongArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected long[] protectedArray() {
        return this.backingArray;
    }

    protected int protectedArrayOffset() {
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return true;
    }

    public LongBuffer put(long c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    public LongBuffer put(int index, long c) {
        this.checkIndex(index);
        this.backingArray[this.offset + index] = c;
        return this;
    }

    public LongBuffer put(long[] src, int srcOffset, int longCount) {
        if (longCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.offset + this.position, longCount);
        this.position += longCount;
        return this;
    }

    public LongBuffer slice() {
        return new ReadWriteLongArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

