/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.ReadOnlyShortArrayBuffer;
import java.nio.ShortArrayBuffer;
import java.nio.ShortBuffer;

final class ReadWriteShortArrayBuffer
extends ShortArrayBuffer {
    static ReadWriteShortArrayBuffer copy(ShortArrayBuffer other, int markOfOther) {
        ReadWriteShortArrayBuffer buf = new ReadWriteShortArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteShortArrayBuffer(short[] array) {
        super(array);
    }

    ReadWriteShortArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteShortArrayBuffer(int capacity, short[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return ReadOnlyShortArrayBuffer.copy(this, this.mark);
    }

    public ShortBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public ShortBuffer duplicate() {
        return ReadWriteShortArrayBuffer.copy(this, this.mark);
    }

    public boolean isReadOnly() {
        return false;
    }

    protected short[] protectedArray() {
        return this.backingArray;
    }

    protected int protectedArrayOffset() {
        return this.offset;
    }

    protected boolean protectedHasArray() {
        return true;
    }

    public ShortBuffer put(short c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    public ShortBuffer put(int index, short c) {
        this.checkIndex(index);
        this.backingArray[this.offset + index] = c;
        return this;
    }

    public ShortBuffer put(short[] src, int srcOffset, int shortCount) {
        if (shortCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, srcOffset, this.backingArray, this.offset + this.position, shortCount);
        this.position += shortCount;
        return this;
    }

    public ShortBuffer slice() {
        return new ReadWriteShortArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

