/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.SelectorImpl;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;

final class SelectionKeyImpl
extends AbstractSelectionKey {
    private AbstractSelectableChannel channel;
    private int interestOps;
    private int readyOps;
    private SelectorImpl selector;

    public SelectionKeyImpl(AbstractSelectableChannel channel, int operations, Object attachment, SelectorImpl selector) {
        this.channel = channel;
        this.interestOps = operations;
        this.selector = selector;
        this.attach(attachment);
    }

    public SelectableChannel channel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int interestOps() {
        this.checkValid();
        Object object = this.selector.keysLock;
        synchronized (object) {
            return this.interestOps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int interestOpsNoCheck() {
        Object object = this.selector.keysLock;
        synchronized (object) {
            return this.interestOps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey interestOps(int operations) {
        this.checkValid();
        if ((operations & ~this.channel().validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.selector.keysLock;
        synchronized (object) {
            this.interestOps = operations;
        }
        return this;
    }

    public int readyOps() {
        this.checkValid();
        return this.readyOps;
    }

    public Selector selector() {
        return this.selector;
    }

    void setReadyOps(int readyOps) {
        this.readyOps = readyOps;
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
    }

    boolean isConnected() {
        return !(this.channel instanceof SocketChannel) || ((SocketChannel)this.channel).isConnected();
    }
}

