/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

abstract class ShortArrayBuffer
extends ShortBuffer {
    protected final short[] backingArray;
    protected final int offset;

    ShortArrayBuffer(short[] array) {
        this(array.length, array, 0);
    }

    ShortArrayBuffer(int capacity) {
        this(capacity, new short[capacity], 0);
    }

    ShortArrayBuffer(int capacity, short[] backingArray, int offset) {
        super(capacity);
        this.backingArray = backingArray;
        this.offset = offset;
    }

    public final short get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.offset + this.position++];
    }

    public final short get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.offset + index];
    }

    public final ShortBuffer get(short[] dst, int dstOffset, int shortCount) {
        if (shortCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backingArray, this.offset + this.position, dst, dstOffset, shortCount);
        this.position += shortCount;
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

