/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import libcore.io.Streams;

public final class Channels {
    private Channels() {
    }

    public static InputStream newInputStream(ReadableByteChannel channel) {
        return new ChannelInputStream(channel);
    }

    public static OutputStream newOutputStream(WritableByteChannel channel) {
        return new ChannelOutputStream(channel);
    }

    public static ReadableByteChannel newChannel(InputStream inputStream) {
        return new InputStreamChannel(inputStream);
    }

    public static WritableByteChannel newChannel(OutputStream outputStream) {
        return new OutputStreamChannel(outputStream);
    }

    public static Reader newReader(ReadableByteChannel channel, CharsetDecoder decoder, int minBufferCapacity) {
        return new InputStreamReader((InputStream)new ChannelInputStream(channel), decoder);
    }

    public static Reader newReader(ReadableByteChannel channel, String charsetName) {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        return Channels.newReader(channel, Charset.forName(charsetName).newDecoder(), -1);
    }

    public static Writer newWriter(WritableByteChannel channel, CharsetEncoder encoder, int minBufferCapacity) {
        return new OutputStreamWriter((OutputStream)new ChannelOutputStream(channel), encoder);
    }

    public static Writer newWriter(WritableByteChannel channel, String charsetName) {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        return Channels.newWriter(channel, Charset.forName(charsetName).newEncoder(), -1);
    }

    static void checkBlocking(Channel channel) {
        if (channel instanceof SelectableChannel && !((SelectableChannel)channel).isBlocking()) {
            throw new IllegalBlockingModeException();
        }
    }

    private static class OutputStreamChannel
    extends AbstractInterruptibleChannel
    implements WritableByteChannel {
        private final OutputStream outputStream;

        OutputStreamChannel(OutputStream outputStream) {
            if (outputStream == null) {
                throw new NullPointerException();
            }
            this.outputStream = outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int write(ByteBuffer source) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int bytesRemain = source.remaining();
            if (bytesRemain == 0) {
                return 0;
            }
            byte[] buf = new byte[bytesRemain];
            source.get(buf);
            try {
                this.begin();
                this.outputStream.write(buf, 0, bytesRemain);
                this.end(bytesRemain >= 0);
            }
            catch (Throwable throwable) {
                this.end(bytesRemain >= 0);
                throw throwable;
            }
            return bytesRemain;
        }

        protected void implCloseChannel() throws IOException {
            this.outputStream.close();
        }
    }

    private static class InputStreamChannel
    extends AbstractInterruptibleChannel
    implements ReadableByteChannel {
        private final InputStream inputStream;

        InputStreamChannel(InputStream inputStream) {
            if (inputStream == null) {
                throw new NullPointerException();
            }
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(ByteBuffer target) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int bytesRemain = target.remaining();
            byte[] bytes = new byte[bytesRemain];
            int readCount = 0;
            try {
                this.begin();
                readCount = this.inputStream.read(bytes);
                this.end(readCount >= 0);
            }
            catch (Throwable throwable) {
                this.end(readCount >= 0);
                throw throwable;
            }
            if (readCount > 0) {
                target.put(bytes, 0, readCount);
            }
            return readCount;
        }

        protected void implCloseChannel() throws IOException {
            this.inputStream.close();
        }
    }

    private static class ChannelOutputStream
    extends OutputStream {
        private final WritableByteChannel channel;

        ChannelOutputStream(WritableByteChannel channel) {
            if (channel == null) {
                throw new NullPointerException();
            }
            this.channel = channel;
        }

        public synchronized void write(int oneByte) throws IOException {
            byte[] wrappedByte = new byte[]{(byte)oneByte};
            this.write(wrappedByte);
        }

        public synchronized void write(byte[] source, int offset, int length) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(source, offset, length);
            Channels.checkBlocking(this.channel);
            for (int total = 0; total < length; total += this.channel.write(buffer)) {
            }
        }

        public synchronized void close() throws IOException {
            this.channel.close();
        }
    }

    private static class ChannelInputStream
    extends InputStream {
        private final ReadableByteChannel channel;

        ChannelInputStream(ReadableByteChannel channel) {
            if (channel == null) {
                throw new NullPointerException();
            }
            this.channel = channel;
        }

        public synchronized int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        public synchronized int read(byte[] target, int offset, int length) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(target, offset, length);
            Channels.checkBlocking(this.channel);
            return this.channel.read(buffer);
        }

        public int available() throws IOException {
            if (this.channel instanceof FileChannel) {
                FileChannel fileChannel = (FileChannel)this.channel;
                long result = fileChannel.size() - fileChannel.position();
                return result > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)result;
            }
            return super.available();
        }

        public synchronized void close() throws IOException {
            this.channel.close();
        }
    }
}

