/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSelectableChannel
extends SelectableChannel {
    private final SelectorProvider provider;
    private List<SelectionKey> keyList = new ArrayList<SelectionKey>();
    private final Object blockingLock = new Object();
    boolean isBlocking = true;

    protected AbstractSelectableChannel(SelectorProvider selectorProvider) {
        this.provider = selectorProvider;
    }

    public final SelectorProvider provider() {
        return this.provider;
    }

    public final synchronized boolean isRegistered() {
        return !this.keyList.isEmpty();
    }

    public final synchronized SelectionKey keyFor(Selector selector) {
        for (SelectionKey key : this.keyList) {
            if (key == null || key.selector() != selector) continue;
            return key;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectionKey register(Selector selector, int interestSet, Object attachment) throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((interestSet & ~this.validOps()) != 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.blockingLock;
        synchronized (object) {
            if (this.isBlocking) {
                throw new IllegalBlockingModeException();
            }
            if (!selector.isOpen()) {
                if (interestSet == 0) {
                    throw new IllegalSelectorException();
                }
                throw new NullPointerException();
            }
            SelectionKey key = this.keyFor(selector);
            if (key == null) {
                key = ((AbstractSelector)selector).register(this, interestSet, attachment);
                this.keyList.add(key);
            } else {
                if (!key.isValid()) {
                    throw new CancelledKeyException();
                }
                key.interestOps(interestSet);
                key.attach(attachment);
            }
            return key;
        }
    }

    protected final synchronized void implCloseChannel() throws IOException {
        this.implCloseSelectableChannel();
        for (SelectionKey key : this.keyList) {
            if (key == null) continue;
            key.cancel();
        }
    }

    protected abstract void implCloseSelectableChannel() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBlocking() {
        Object object = this.blockingLock;
        synchronized (object) {
            return this.isBlocking;
        }
    }

    public final Object blockingLock() {
        return this.blockingLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SelectableChannel configureBlocking(boolean blockingMode) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        Object object = this.blockingLock;
        synchronized (object) {
            if (this.isBlocking == blockingMode) {
                return this;
            }
            if (blockingMode && this.containsValidKeys()) {
                throw new IllegalBlockingModeException();
            }
            this.implConfigureBlocking(blockingMode);
            this.isBlocking = blockingMode;
        }
        return this;
    }

    protected abstract void implConfigureBlocking(boolean var1) throws IOException;

    synchronized void deregister(SelectionKey k) {
        if (this.keyList != null) {
            this.keyList.remove(k);
        }
    }

    private synchronized boolean containsValidKeys() {
        for (SelectionKey key : this.keyList) {
            if (key == null || !key.isValid()) continue;
            return true;
        }
        return false;
    }
}

