/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;
import java.util.Map;
import libcore.icu.ErrorCode;
import libcore.icu.NativeConverter;
import libcore.util.EmptyArray;

final class CharsetEncoderICU
extends CharsetEncoder {
    private static final Map<String, byte[]> DEFAULT_REPLACEMENTS = new HashMap<String, byte[]>();
    private static final int INPUT_OFFSET = 0;
    private static final int OUTPUT_OFFSET = 1;
    private static final int INVALID_CHARS = 2;
    private int[] data = new int[3];
    private long converterHandle = 0L;
    private char[] input = null;
    private byte[] output = null;
    private char[] allocatedInput = null;
    private byte[] allocatedOutput = null;
    private int inEnd;
    private int outEnd;
    private int ec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CharsetEncoderICU newInstance(Charset cs, String icuCanonicalName) {
        long address = 0L;
        try {
            address = NativeConverter.openConverter(icuCanonicalName);
            float averageBytesPerChar = NativeConverter.getAveBytesPerChar(address);
            float maxBytesPerChar = NativeConverter.getMaxBytesPerChar(address);
            byte[] replacement = CharsetEncoderICU.makeReplacement(icuCanonicalName, address);
            CharsetEncoderICU result = new CharsetEncoderICU(cs, averageBytesPerChar, maxBytesPerChar, replacement, address);
            address = 0L;
            CharsetEncoderICU charsetEncoderICU = result;
            return charsetEncoderICU;
        }
        finally {
            if (address != 0L) {
                NativeConverter.closeConverter(address);
            }
        }
    }

    private static byte[] makeReplacement(String icuCanonicalName, long address) {
        byte[] replacement = DEFAULT_REPLACEMENTS.get(icuCanonicalName);
        if (replacement != null) {
            return (byte[])replacement.clone();
        }
        return NativeConverter.getSubstitutionBytes(address);
    }

    private CharsetEncoderICU(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement, long address) {
        super(cs, averageBytesPerChar, maxBytesPerChar, replacement, true);
        this.converterHandle = address;
        this.updateCallback();
    }

    protected void implReplaceWith(byte[] newReplacement) {
        this.updateCallback();
    }

    protected void implOnMalformedInput(CodingErrorAction newAction) {
        this.updateCallback();
    }

    protected void implOnUnmappableCharacter(CodingErrorAction newAction) {
        this.updateCallback();
    }

    private void updateCallback() {
        this.ec = NativeConverter.setCallbackEncode(this.converterHandle, this);
        if (ErrorCode.isFailure(this.ec)) {
            throw ErrorCode.throwException(this.ec);
        }
    }

    protected void implReset() {
        NativeConverter.resetCharToByte(this.converterHandle);
        this.data[0] = 0;
        this.data[1] = 0;
        this.data[2] = 0;
        this.output = null;
        this.input = null;
        this.allocatedInput = null;
        this.allocatedOutput = null;
        this.ec = 0;
        this.inEnd = 0;
        this.outEnd = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult implFlush(ByteBuffer out) {
        try {
            this.input = EmptyArray.CHAR;
            this.inEnd = 0;
            this.data[0] = 0;
            this.data[1] = this.getArray(out);
            this.data[2] = 0;
            this.ec = NativeConverter.encode(this.converterHandle, this.input, this.inEnd, this.output, this.outEnd, this.data, true);
            if (ErrorCode.isFailure(this.ec)) {
                if (this.ec == 15) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.ec == 11) {
                    if (this.data[0] > 0) {
                        CoderResult coderResult = CoderResult.malformedForLength(this.data[0]);
                        return coderResult;
                    }
                } else {
                    throw ErrorCode.throwException(this.ec);
                }
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            this.setPosition(out);
            this.implReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        if (!in.hasRemaining()) {
            return CoderResult.UNDERFLOW;
        }
        this.data[0] = this.getArray(in);
        this.data[1] = this.getArray(out);
        this.data[2] = 0;
        try {
            this.ec = NativeConverter.encode(this.converterHandle, this.input, this.inEnd, this.output, this.outEnd, this.data, false);
            if (ErrorCode.isFailure(this.ec)) {
                if (this.ec == 15) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                if (this.ec == 10) {
                    CoderResult coderResult = CoderResult.unmappableForLength(this.data[2]);
                    return coderResult;
                }
                if (this.ec == 12) {
                    CoderResult coderResult = CoderResult.malformedForLength(this.data[2]);
                    return coderResult;
                }
                throw new AssertionError((Object)("unexpected failure: " + this.ec));
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            this.setPosition(in);
            this.setPosition(out);
        }
    }

    public boolean canEncode(char c) {
        return this.canEncode((int)c);
    }

    public boolean canEncode(int codePoint) {
        return NativeConverter.canEncode(this.converterHandle, codePoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            NativeConverter.closeConverter(this.converterHandle);
            this.converterHandle = 0L;
        }
        finally {
            super.finalize();
        }
    }

    private int getArray(ByteBuffer out) {
        if (out.hasArray()) {
            this.output = out.array();
            this.outEnd = out.arrayOffset() + out.limit();
            return out.arrayOffset() + out.position();
        }
        this.outEnd = out.remaining();
        if (this.allocatedOutput == null || this.outEnd > this.allocatedOutput.length) {
            this.allocatedOutput = new byte[this.outEnd];
        }
        this.output = this.allocatedOutput;
        return 0;
    }

    private int getArray(CharBuffer in) {
        if (in.hasArray()) {
            this.input = in.array();
            this.inEnd = in.arrayOffset() + in.limit();
            return in.arrayOffset() + in.position();
        }
        this.inEnd = in.remaining();
        if (this.allocatedInput == null || this.inEnd > this.allocatedInput.length) {
            this.allocatedInput = new char[this.inEnd];
        }
        int pos = in.position();
        in.get(this.allocatedInput, 0, this.inEnd);
        in.position(pos);
        this.input = this.allocatedInput;
        return 0;
    }

    private void setPosition(ByteBuffer out) {
        if (out.hasArray()) {
            out.position(out.position() + this.data[1] - out.arrayOffset());
        } else {
            out.put(this.output, 0, this.data[1]);
        }
        this.output = null;
    }

    private void setPosition(CharBuffer in) {
        in.position(in.position() + this.data[0] - this.data[2]);
        this.input = null;
    }

    static {
        byte[] questionMark = new byte[]{63};
        DEFAULT_REPLACEMENTS.put("UTF-8", questionMark);
        DEFAULT_REPLACEMENTS.put("ISO-8859-1", questionMark);
        DEFAULT_REPLACEMENTS.put("US-ASCII", questionMark);
    }
}

