/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.harmony.security.fortress.Engine;

public class AlgorithmParameterGenerator {
    private static final String SERVICE = "AlgorithmParameterGenerator";
    private static final Engine ENGINE = new Engine("AlgorithmParameterGenerator");
    private static final SecureRandom RANDOM = new SecureRandom();
    private final Provider provider;
    private final AlgorithmParameterGeneratorSpi spiImpl;
    private final String algorithm;

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi paramGenSpi, Provider provider, String algorithm) {
        this.provider = provider;
        this.algorithm = algorithm;
        this.spiImpl = paramGenSpi;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameterGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        Engine.SpiAndProvider sap = ENGINE.getInstance(algorithm, null);
        return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)sap.spi, sap.provider, algorithm);
    }

    public static AlgorithmParameterGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Provider impProvider = Security.getProvider(provider);
        if (impProvider == null) {
            throw new NoSuchProviderException(provider);
        }
        return AlgorithmParameterGenerator.getInstance(algorithm, impProvider);
    }

    public static AlgorithmParameterGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        if (algorithm == null) {
            throw new NullPointerException();
        }
        Object spi = ENGINE.getInstance(algorithm, provider, null);
        return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)spi, provider, algorithm);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int size) {
        this.spiImpl.engineInit(size, RANDOM);
    }

    public final void init(int size, SecureRandom random) {
        this.spiImpl.engineInit(size, random);
    }

    public final void init(AlgorithmParameterSpec genParamSpec) throws InvalidAlgorithmParameterException {
        this.spiImpl.engineInit(genParamSpec, RANDOM);
    }

    public final void init(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.spiImpl.engineInit(genParamSpec, random);
    }

    public final AlgorithmParameters generateParameters() {
        return this.spiImpl.engineGenerateParameters();
    }
}

