/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyStoreSpi {
    public abstract Key engineGetKey(String var1, char[] var2) throws NoSuchAlgorithmException, UnrecoverableKeyException;

    public abstract Certificate[] engineGetCertificateChain(String var1);

    public abstract Certificate engineGetCertificate(String var1);

    public abstract Date engineGetCreationDate(String var1);

    public abstract void engineSetKeyEntry(String var1, Key var2, char[] var3, Certificate[] var4) throws KeyStoreException;

    public abstract void engineSetKeyEntry(String var1, byte[] var2, Certificate[] var3) throws KeyStoreException;

    public abstract void engineSetCertificateEntry(String var1, Certificate var2) throws KeyStoreException;

    public abstract void engineDeleteEntry(String var1) throws KeyStoreException;

    public abstract Enumeration<String> engineAliases();

    public abstract boolean engineContainsAlias(String var1);

    public abstract int engineSize();

    public abstract boolean engineIsKeyEntry(String var1);

    public abstract boolean engineIsCertificateEntry(String var1);

    public abstract String engineGetCertificateAlias(Certificate var1);

    public abstract void engineStore(OutputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException();
    }

    public abstract void engineLoad(InputStream var1, char[] var2) throws IOException, NoSuchAlgorithmException, CertificateException;

    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            this.engineLoad(null, null);
            return;
        }
        KeyStore.ProtectionParameter pp = param.getProtectionParameter();
        if (pp instanceof KeyStore.PasswordProtection) {
            try {
                char[] pwd = ((KeyStore.PasswordProtection)pp).getPassword();
                this.engineLoad(null, pwd);
                return;
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (pp instanceof KeyStore.CallbackHandlerProtection) {
            try {
                char[] pwd = KeyStoreSpi.getPasswordFromCallBack(pp);
                this.engineLoad(null, pwd);
                return;
            }
            catch (UnrecoverableEntryException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new UnsupportedOperationException("protectionParameter is neither PasswordProtection nor CallbackHandlerProtection instance");
    }

    public KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        if (this.engineIsCertificateEntry(alias)) {
            return new KeyStore.TrustedCertificateEntry(this.engineGetCertificate(alias));
        }
        char[] passW = null;
        if (protParam != null) {
            if (protParam instanceof KeyStore.PasswordProtection) {
                try {
                    passW = ((KeyStore.PasswordProtection)protParam).getPassword();
                }
                catch (IllegalStateException ee) {
                    throw new KeyStoreException("Password was destroyed", ee);
                }
            } else if (protParam instanceof KeyStore.CallbackHandlerProtection) {
                passW = KeyStoreSpi.getPasswordFromCallBack(protParam);
            } else {
                throw new UnrecoverableEntryException("ProtectionParameter object is not PasswordProtection: " + protParam);
            }
        }
        if (this.engineIsKeyEntry(alias)) {
            Key key = this.engineGetKey(alias, passW);
            if (key instanceof PrivateKey) {
                return new KeyStore.PrivateKeyEntry((PrivateKey)key, this.engineGetCertificateChain(alias));
            }
            if (key instanceof SecretKey) {
                return new KeyStore.SecretKeyEntry((SecretKey)key);
            }
        }
        throw new NoSuchAlgorithmException("Unknown KeyStore.Entry object");
    }

    public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (entry == null) {
            throw new KeyStoreException("entry == null");
        }
        if (this.engineContainsAlias(alias)) {
            this.engineDeleteEntry(alias);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry trE = (KeyStore.TrustedCertificateEntry)entry;
            this.engineSetCertificateEntry(alias, trE.getTrustedCertificate());
            return;
        }
        char[] passW = null;
        if (protParam instanceof KeyStore.PasswordProtection) {
            try {
                passW = ((KeyStore.PasswordProtection)protParam).getPassword();
            }
            catch (IllegalStateException ee) {
                throw new KeyStoreException("Password was destroyed", ee);
            }
        } else if (protParam instanceof KeyStore.CallbackHandlerProtection) {
            try {
                passW = KeyStoreSpi.getPasswordFromCallBack(protParam);
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
        } else {
            throw new KeyStoreException("protParam should be PasswordProtection or CallbackHandlerProtection");
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry prE = (KeyStore.PrivateKeyEntry)entry;
            this.engineSetKeyEntry(alias, prE.getPrivateKey(), passW, prE.getCertificateChain());
            return;
        }
        if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry skE = (KeyStore.SecretKeyEntry)entry;
            this.engineSetKeyEntry(alias, skE.getSecretKey(), passW, null);
            return;
        }
        throw new KeyStoreException("Entry object is neither PrivateKeyObject nor SecretKeyEntry nor TrustedCertificateEntry: " + entry);
    }

    public boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        if (!this.engineContainsAlias(alias)) {
            return false;
        }
        try {
            if (this.engineIsCertificateEntry(alias)) {
                return entryClass.isAssignableFrom(Class.forName("java.security.KeyStore$TrustedCertificateEntry"));
            }
            if (this.engineIsKeyEntry(alias)) {
                if (entryClass.isAssignableFrom(Class.forName("java.security.KeyStore$PrivateKeyEntry"))) {
                    return this.engineGetCertificate(alias) != null;
                }
                if (entryClass.isAssignableFrom(Class.forName("java.security.KeyStore$SecretKeyEntry"))) {
                    return this.engineGetCertificate(alias) == null;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static char[] getPasswordFromCallBack(KeyStore.ProtectionParameter protParam) throws UnrecoverableEntryException {
        if (protParam == null) {
            return null;
        }
        if (!(protParam instanceof KeyStore.CallbackHandlerProtection)) {
            throw new UnrecoverableEntryException("Incorrect ProtectionParameter");
        }
        String clName = Security.getProperty("auth.login.defaultCallbackHandler");
        if (clName == null) {
            throw new UnrecoverableEntryException("Default CallbackHandler was not defined");
        }
        try {
            Class<?> cl = Class.forName(clName);
            CallbackHandler cbHand = (CallbackHandler)cl.newInstance();
            Callback[] pwCb = new PasswordCallback[]{new PasswordCallback("password: ", true)};
            cbHand.handle(pwCb);
            return ((PasswordCallback)pwCb[0]).getPassword();
        }
        catch (Exception e) {
            throw new UnrecoverableEntryException(e.toString());
        }
    }
}

