/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.cert.CertStoreParameters;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionCertStoreParameters
implements CertStoreParameters {
    private static final Collection<?> defaultCollection = Collections.EMPTY_SET;
    private final Collection<?> collection;

    public CollectionCertStoreParameters() {
        this.collection = defaultCollection;
    }

    public CollectionCertStoreParameters(Collection<?> collection) {
        this.collection = collection;
        if (this.collection == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CollectionCertStoreParameters: [\ncollection: ");
        sb.append(this.getCollection().toString());
        sb.append("\n]");
        return sb.toString();
    }
}

