/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.cert.CertStoreParameters;

public class LDAPCertStoreParameters
implements CertStoreParameters {
    private static final String DEFAULT_LDAP_SERVER_NAME = "localhost";
    private static final int DEFAULT_LDAP_PORT = 389;
    private final String serverName;
    private final int port;

    public LDAPCertStoreParameters(String serverName, int port) {
        this.port = port;
        this.serverName = serverName;
        if (this.serverName == null) {
            throw new NullPointerException();
        }
    }

    public LDAPCertStoreParameters() {
        this.serverName = DEFAULT_LDAP_SERVER_NAME;
        this.port = 389;
    }

    public LDAPCertStoreParameters(String serverName) {
        this.port = 389;
        this.serverName = serverName;
        if (this.serverName == null) {
            throw new NullPointerException();
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LDAPCertStoreParameters: [\n serverName: ");
        sb.append(this.getServerName());
        sb.append("\n port: ");
        sb.append(this.getPort());
        sb.append("\n]");
        return sb.toString();
    }
}

