/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class X509CRL
extends CRL
implements X509Extension {
    protected X509CRL() {
        super("X.509");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof X509CRL)) {
            return false;
        }
        X509CRL obj = (X509CRL)other;
        try {
            return Arrays.equals(this.getEncoded(), obj.getEncoded());
        }
        catch (CRLException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            int res = 0;
            byte[] array = this.getEncoded();
            for (int i = 0; i < array.length; ++i) {
                res += array[i] & 0xFF;
            }
            return res;
        }
        catch (CRLException e) {
            return 0;
        }
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract void verify(PublicKey var1) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract int getVersion();

    public abstract Principal getIssuerDN();

    public X500Principal getIssuerX500Principal() {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)factory.generateCRL(new ByteArrayInputStream(this.getEncoded()));
            return crl.getIssuerX500Principal();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get X500Principal issuer", e);
        }
    }

    public abstract Date getThisUpdate();

    public abstract Date getNextUpdate();

    public abstract X509CRLEntry getRevokedCertificate(BigInteger var1);

    public X509CRLEntry getRevokedCertificate(X509Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException();
        }
        return this.getRevokedCertificate(certificate.getSerialNumber());
    }

    public abstract Set<? extends X509CRLEntry> getRevokedCertificates();

    public abstract byte[] getTBSCertList() throws CRLException;

    public abstract byte[] getSignature();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();
}

