/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECParameterSpec
implements AlgorithmParameterSpec {
    private final EllipticCurve curve;
    private final ECPoint generator;
    private final BigInteger order;
    private final int cofactor;

    public ECParameterSpec(EllipticCurve curve, ECPoint generator, BigInteger order, int cofactor) {
        this.curve = curve;
        this.generator = generator;
        this.order = order;
        this.cofactor = cofactor;
        if (this.curve == null) {
            throw new NullPointerException("curve == null");
        }
        if (this.generator == null) {
            throw new NullPointerException("generator == null");
        }
        if (this.order == null) {
            throw new NullPointerException("order == null");
        }
        if (this.order.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("order <= 0");
        }
        if (this.cofactor <= 0) {
            throw new IllegalArgumentException("cofactor <= 0");
        }
    }

    public int getCofactor() {
        return this.cofactor;
    }

    public EllipticCurve getCurve() {
        return this.curve;
    }

    public ECPoint getGenerator() {
        return this.generator;
    }

    public BigInteger getOrder() {
        return this.order;
    }
}

