/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.RuleBasedBreakIterator;
import java.util.Locale;
import libcore.icu.ICU;
import libcore.icu.NativeBreakIterator;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;
    NativeBreakIterator wrapped;

    protected BreakIterator() {
    }

    BreakIterator(NativeBreakIterator iterator) {
        this.wrapped = iterator;
    }

    public static Locale[] getAvailableLocales() {
        return ICU.getAvailableBreakIteratorLocales();
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale where) {
        return new RuleBasedBreakIterator(NativeBreakIterator.getCharacterInstance(where));
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale where) {
        return new RuleBasedBreakIterator(NativeBreakIterator.getLineInstance(where));
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale where) {
        return new RuleBasedBreakIterator(NativeBreakIterator.getSentenceInstance(where));
    }

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale where) {
        return new RuleBasedBreakIterator(NativeBreakIterator.getWordInstance(where));
    }

    public boolean isBoundary(int offset) {
        return this.wrapped.isBoundary(offset);
    }

    public int preceding(int offset) {
        return this.wrapped.preceding(offset);
    }

    public void setText(String newText) {
        this.wrapped.setText(newText);
    }

    public abstract int current();

    public abstract int first();

    public abstract int following(int var1);

    public abstract CharacterIterator getText();

    public abstract int last();

    public abstract int next();

    public abstract int next(int var1);

    public abstract int previous();

    public abstract void setText(CharacterIterator var1);

    public Object clone() {
        try {
            BreakIterator cloned = (BreakIterator)super.clone();
            cloned.wrapped = (NativeBreakIterator)this.wrapped.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

