/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Currency;
import java.util.Locale;
import libcore.icu.ICU;
import libcore.icu.LocaleData;

public class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5772796243397350300L;
    private char zeroDigit;
    private char digit;
    private char decimalSeparator;
    private char groupingSeparator;
    private char patternSeparator;
    private char percent;
    private char perMill;
    private char monetarySeparator;
    private char minusSign;
    private String infinity;
    private String NaN;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private transient Currency currency;
    private transient Locale locale;
    private transient String exponentSeparator;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("currencySymbol", String.class), new ObjectStreamField("decimalSeparator", Character.TYPE), new ObjectStreamField("digit", Character.TYPE), new ObjectStreamField("exponential", Character.TYPE), new ObjectStreamField("exponentialSeparator", String.class), new ObjectStreamField("groupingSeparator", Character.TYPE), new ObjectStreamField("infinity", String.class), new ObjectStreamField("intlCurrencySymbol", String.class), new ObjectStreamField("minusSign", Character.TYPE), new ObjectStreamField("monetarySeparator", Character.TYPE), new ObjectStreamField("NaN", String.class), new ObjectStreamField("patternSeparator", Character.TYPE), new ObjectStreamField("percent", Character.TYPE), new ObjectStreamField("perMill", Character.TYPE), new ObjectStreamField("serialVersionOnStream", Integer.TYPE), new ObjectStreamField("zeroDigit", Character.TYPE), new ObjectStreamField("locale", Locale.class)};

    public DecimalFormatSymbols() {
        this(Locale.getDefault());
    }

    public DecimalFormatSymbols(Locale locale) {
        LocaleData localeData = LocaleData.get(locale);
        this.zeroDigit = localeData.zeroDigit;
        this.digit = (char)35;
        this.decimalSeparator = localeData.decimalSeparator;
        this.groupingSeparator = localeData.groupingSeparator;
        this.patternSeparator = localeData.patternSeparator;
        this.percent = localeData.percent;
        this.perMill = localeData.perMill;
        this.monetarySeparator = localeData.monetarySeparator;
        this.minusSign = localeData.minusSign;
        this.infinity = localeData.infinity;
        this.NaN = localeData.NaN;
        this.exponentSeparator = localeData.exponentSeparator;
        this.locale = locale;
        try {
            this.currency = Currency.getInstance(locale);
            this.currencySymbol = this.currency.getSymbol(locale);
            this.intlCurrencySymbol = this.currency.getCurrencyCode();
        }
        catch (IllegalArgumentException e) {
            this.currency = Currency.getInstance("XXX");
            this.currencySymbol = localeData.currencySymbol;
            this.intlCurrencySymbol = localeData.internationalCurrencySymbol;
        }
    }

    public static DecimalFormatSymbols getInstance() {
        return DecimalFormatSymbols.getInstance(Locale.getDefault());
    }

    public static DecimalFormatSymbols getInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        return new DecimalFormatSymbols(locale);
    }

    public static Locale[] getAvailableLocales() {
        return ICU.getAvailableDecimalFormatSymbolsLocales();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DecimalFormatSymbols)) {
            return false;
        }
        DecimalFormatSymbols obj = (DecimalFormatSymbols)object;
        return this.currency.equals(obj.currency) && this.currencySymbol.equals(obj.currencySymbol) && this.decimalSeparator == obj.decimalSeparator && this.digit == obj.digit && this.exponentSeparator.equals(obj.exponentSeparator) && this.groupingSeparator == obj.groupingSeparator && this.infinity.equals(obj.infinity) && this.intlCurrencySymbol.equals(obj.intlCurrencySymbol) && this.minusSign == obj.minusSign && this.monetarySeparator == obj.monetarySeparator && this.NaN.equals(obj.NaN) && this.patternSeparator == obj.patternSeparator && this.perMill == obj.perMill && this.percent == obj.percent && this.zeroDigit == obj.zeroDigit;
    }

    public String toString() {
        return this.getClass().getName() + "[currency=" + this.currency + ",currencySymbol=" + this.currencySymbol + ",decimalSeparator=" + this.decimalSeparator + ",digit=" + this.digit + ",exponentSeparator=" + this.exponentSeparator + ",groupingSeparator=" + this.groupingSeparator + ",infinity=" + this.infinity + ",intlCurrencySymbol=" + this.intlCurrencySymbol + ",minusSign=" + this.minusSign + ",monetarySeparator=" + this.monetarySeparator + ",NaN=" + this.NaN + ",patternSeparator=" + this.patternSeparator + ",perMill=" + this.perMill + ",percent=" + this.percent + ",zeroDigit=" + this.zeroDigit + "]";
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getDigit() {
        return this.digit;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public String getNaN() {
        return this.NaN;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public char getPercent() {
        return this.percent;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.zeroDigit;
        result = 31 * result + this.digit;
        result = 31 * result + this.decimalSeparator;
        result = 31 * result + this.groupingSeparator;
        result = 31 * result + this.patternSeparator;
        result = 31 * result + this.percent;
        result = 31 * result + this.perMill;
        result = 31 * result + this.monetarySeparator;
        result = 31 * result + this.minusSign;
        result = 31 * result + this.exponentSeparator.hashCode();
        result = 31 * result + this.infinity.hashCode();
        result = 31 * result + this.NaN.hashCode();
        result = 31 * result + this.currencySymbol.hashCode();
        result = 31 * result + this.intlCurrencySymbol.hashCode();
        return result;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        if (currency == this.currency) {
            return;
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.locale);
    }

    public void setInternationalCurrencySymbol(String value) {
        if (value == null) {
            this.currency = null;
            this.intlCurrencySymbol = null;
            return;
        }
        if (value.equals(this.intlCurrencySymbol)) {
            return;
        }
        try {
            this.currency = Currency.getInstance(value);
            this.currencySymbol = this.currency.getSymbol(this.locale);
        }
        catch (IllegalArgumentException e) {
            this.currency = null;
        }
        this.intlCurrencySymbol = value;
    }

    public void setCurrencySymbol(String value) {
        this.currencySymbol = value;
    }

    public void setDecimalSeparator(char value) {
        this.decimalSeparator = value;
    }

    public void setDigit(char value) {
        this.digit = value;
    }

    public void setGroupingSeparator(char value) {
        this.groupingSeparator = value;
    }

    public void setInfinity(String value) {
        this.infinity = value;
    }

    public void setMinusSign(char value) {
        this.minusSign = value;
    }

    public void setMonetaryDecimalSeparator(char value) {
        this.monetarySeparator = value;
    }

    public void setNaN(String value) {
        this.NaN = value;
    }

    public void setPatternSeparator(char value) {
        this.patternSeparator = value;
    }

    public void setPercent(char value) {
        this.percent = value;
    }

    public void setPerMill(char value) {
        this.perMill = value;
    }

    public void setZeroDigit(char value) {
        this.zeroDigit = value;
    }

    public void setExponentSeparator(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.exponentSeparator = value;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("currencySymbol", this.currencySymbol);
        fields.put("decimalSeparator", this.getDecimalSeparator());
        fields.put("digit", this.getDigit());
        fields.put("exponential", this.exponentSeparator.charAt(0));
        fields.put("exponentialSeparator", this.exponentSeparator);
        fields.put("groupingSeparator", this.getGroupingSeparator());
        fields.put("infinity", this.infinity);
        fields.put("intlCurrencySymbol", this.intlCurrencySymbol);
        fields.put("minusSign", this.getMinusSign());
        fields.put("monetarySeparator", this.getMonetaryDecimalSeparator());
        fields.put("NaN", this.NaN);
        fields.put("patternSeparator", this.getPatternSeparator());
        fields.put("percent", this.getPercent());
        fields.put("perMill", this.getPerMill());
        fields.put("serialVersionOnStream", 3);
        fields.put("zeroDigit", this.getZeroDigit());
        fields.put("locale", this.locale);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        int serialVersionOnStream = fields.get("serialVersionOnStream", 0);
        this.currencySymbol = (String)fields.get("currencySymbol", "");
        this.setDecimalSeparator(fields.get("decimalSeparator", '.'));
        this.setDigit(fields.get("digit", '#'));
        this.setGroupingSeparator(fields.get("groupingSeparator", ','));
        this.infinity = (String)fields.get("infinity", "");
        this.intlCurrencySymbol = (String)fields.get("intlCurrencySymbol", "");
        this.setMinusSign(fields.get("minusSign", '-'));
        this.NaN = (String)fields.get("NaN", "");
        this.setPatternSeparator(fields.get("patternSeparator", ';'));
        this.setPercent(fields.get("percent", '%'));
        this.setPerMill(fields.get("perMill", '\u2030'));
        this.setZeroDigit(fields.get("zeroDigit", '0'));
        this.locale = (Locale)fields.get("locale", null);
        if (serialVersionOnStream == 0) {
            this.setMonetaryDecimalSeparator(this.getDecimalSeparator());
        } else {
            this.setMonetaryDecimalSeparator(fields.get("monetarySeparator", '.'));
        }
        if (serialVersionOnStream == 0) {
            this.exponentSeparator = "E";
        } else if (serialVersionOnStream < 3) {
            this.setExponentSeparator(String.valueOf(fields.get("exponential", 'E')));
        } else {
            this.setExponentSeparator((String)fields.get("exponentialSeparator", "E"));
        }
        try {
            this.currency = Currency.getInstance(this.intlCurrencySymbol);
        }
        catch (IllegalArgumentException e) {
            this.currency = null;
        }
    }
}

