/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import libcore.icu.NativeBreakIterator;

class RuleBasedBreakIterator
extends BreakIterator {
    RuleBasedBreakIterator(NativeBreakIterator iterator) {
        super(iterator);
    }

    public int current() {
        return this.wrapped.current();
    }

    public int first() {
        return this.wrapped.first();
    }

    public int following(int offset) {
        this.validateOffset(offset);
        return this.wrapped.following(offset);
    }

    private void validateOffset(int offset) {
        CharacterIterator it = this.wrapped.getText();
        if (offset < it.getBeginIndex() || offset > it.getEndIndex()) {
            String message = "Valid range is [" + it.getBeginIndex() + " " + it.getEndIndex() + "]";
            throw new IllegalArgumentException(message);
        }
    }

    public CharacterIterator getText() {
        return this.wrapped.getText();
    }

    public int last() {
        return this.wrapped.last();
    }

    public int next() {
        return this.wrapped.next();
    }

    public int next(int n) {
        return this.wrapped.next(n);
    }

    public int previous() {
        return this.wrapped.previous();
    }

    public void setText(CharacterIterator newText) {
        newText.current();
        this.wrapped.setText(newText);
    }

    public boolean isBoundary(int offset) {
        this.validateOffset(offset);
        return this.wrapped.isBoundary(offset);
    }

    public int preceding(int offset) {
        this.validateOffset(offset);
        return this.wrapped.preceding(offset);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RuleBasedBreakIterator)) {
            return false;
        }
        return this.wrapped.equals(((RuleBasedBreakIterator)o).wrapped);
    }

    public String toString() {
        return this.wrapped.toString();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public Object clone() {
        RuleBasedBreakIterator cloned = (RuleBasedBreakIterator)super.clone();
        cloned.wrapped = (NativeBreakIterator)this.wrapped.clone();
        return cloned;
    }
}

