/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import libcore.icu.LocaleData;
import libcore.icu.TimeZones;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    static final String PATTERN_CHARS = "GyMdkHmsSEDFwWahKzZLc";
    private static final int RFC_822_TIMEZONE_FIELD = 18;
    private static final int STAND_ALONE_MONTH_FIELD = 19;
    private static final int STAND_ALONE_DAY_OF_WEEK_FIELD = 20;
    private String pattern;
    private DateFormatSymbols formatData;
    private transient int creationYear;
    private Date defaultCenturyStart;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("defaultCenturyStart", Date.class), new ObjectStreamField("formatData", DateFormatSymbols.class), new ObjectStreamField("pattern", String.class), new ObjectStreamField("serialVersionOnStream", Integer.TYPE)};

    public SimpleDateFormat() {
        this(Locale.getDefault());
        this.pattern = SimpleDateFormat.defaultPattern();
        this.formatData = new DateFormatSymbols(Locale.getDefault());
    }

    public SimpleDateFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    private void validateFormat(char format) {
        int index = PATTERN_CHARS.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown pattern character '" + format + "'");
        }
    }

    private void validatePattern(String template) {
        boolean quote = false;
        int last = -1;
        int count = 0;
        int patternLength = template.length();
        for (int i = 0; i < patternLength; ++i) {
            int next = template.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    this.validateFormat((char)last);
                    count = 0;
                }
                last = last == next ? -1 : next;
                quote = !quote;
                continue;
            }
            if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                    continue;
                }
                if (count > 0) {
                    this.validateFormat((char)last);
                }
                last = next;
                count = 1;
                continue;
            }
            if (count > 0) {
                this.validateFormat((char)last);
                count = 0;
            }
            last = -1;
        }
        if (count > 0) {
            this.validateFormat((char)last);
        }
        if (quote) {
            throw new IllegalArgumentException("Unterminated quote");
        }
    }

    public SimpleDateFormat(String template, DateFormatSymbols value) {
        this(Locale.getDefault());
        this.validatePattern(template);
        this.pattern = template;
        this.formatData = (DateFormatSymbols)value.clone();
    }

    public SimpleDateFormat(String template, Locale locale) {
        this(locale);
        this.validatePattern(template);
        this.pattern = template;
        this.formatData = new DateFormatSymbols(locale);
    }

    private SimpleDateFormat(Locale locale) {
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setGroupingUsed(false);
        this.calendar = new GregorianCalendar(locale);
        this.calendar.add(1, -80);
        this.creationYear = this.calendar.get(1);
        this.defaultCenturyStart = this.calendar.getTime();
    }

    public void applyLocalizedPattern(String template) {
        this.pattern = SimpleDateFormat.convertPattern(template, this.formatData.getLocalPatternChars(), PATTERN_CHARS, true);
    }

    public void applyPattern(String template) {
        this.validatePattern(template);
        this.pattern = template;
    }

    @Override
    public Object clone() {
        SimpleDateFormat clone = (SimpleDateFormat)super.clone();
        clone.formatData = (DateFormatSymbols)this.formatData.clone();
        clone.defaultCenturyStart = new Date(this.defaultCenturyStart.getTime());
        return clone;
    }

    private static String defaultPattern() {
        LocaleData localeData = LocaleData.get(Locale.getDefault());
        return localeData.getDateFormat(3) + " " + localeData.getTimeFormat(3);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat simple = (SimpleDateFormat)object;
        return super.equals(object) && this.pattern.equals(simple.pattern) && this.formatData.equals(simple.formatData);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof Date) {
            return this.formatToCharacterIteratorImpl((Date)object);
        }
        if (object instanceof Number) {
            return this.formatToCharacterIteratorImpl(new Date(((Number)object).longValue()));
        }
        throw new IllegalArgumentException();
    }

    private AttributedCharacterIterator formatToCharacterIteratorImpl(Date date) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<FieldPosition> fields = new ArrayList<FieldPosition>();
        this.formatImpl(date, buffer, null, fields);
        AttributedString as = new AttributedString(buffer.toString());
        for (FieldPosition pos : fields) {
            Format.Field attribute = pos.getFieldAttribute();
            as.addAttribute(attribute, attribute, pos.getBeginIndex(), pos.getEndIndex());
        }
        return as.getIterator();
    }

    private StringBuffer formatImpl(Date date, StringBuffer buffer, FieldPosition field, List<FieldPosition> fields) {
        boolean quote = false;
        int last = -1;
        int count = 0;
        this.calendar.setTime(date);
        if (field != null) {
            field.clear();
        }
        int patternLength = this.pattern.length();
        for (int i = 0; i < patternLength; ++i) {
            int next = this.pattern.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    this.append(buffer, field, fields, (char)last, count);
                    count = 0;
                }
                if (last == next) {
                    buffer.append('\'');
                    last = -1;
                } else {
                    last = next;
                }
                quote = !quote;
                continue;
            }
            if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                    continue;
                }
                if (count > 0) {
                    this.append(buffer, field, fields, (char)last, count);
                }
                last = next;
                count = 1;
                continue;
            }
            if (count > 0) {
                this.append(buffer, field, fields, (char)last, count);
                count = 0;
            }
            last = -1;
            buffer.append((char)next);
        }
        if (count > 0) {
            this.append(buffer, field, fields, (char)last, count);
        }
        return buffer;
    }

    private void append(StringBuffer buffer, FieldPosition position, List<FieldPosition> fields, char format, int count) {
        int field = -1;
        int index = PATTERN_CHARS.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown pattern character '" + format + "'");
        }
        int beginPosition = buffer.length();
        DateFormat.Field dateFormatField = null;
        switch (index) {
            case 0: {
                dateFormatField = DateFormat.Field.ERA;
                buffer.append(this.formatData.eras[this.calendar.get(0)]);
                break;
            }
            case 1: {
                dateFormatField = DateFormat.Field.YEAR;
                int year = this.calendar.get(1);
                if (count == 2) {
                    this.appendNumber(buffer, 2, year % 100);
                    break;
                }
                this.appendNumber(buffer, count, year);
                break;
            }
            case 19: {
                dateFormatField = DateFormat.Field.MONTH;
                this.appendMonth(buffer, count, this.formatData.longStandAloneMonths, this.formatData.shortStandAloneMonths);
                break;
            }
            case 2: {
                dateFormatField = DateFormat.Field.MONTH;
                this.appendMonth(buffer, count, this.formatData.months, this.formatData.shortMonths);
                break;
            }
            case 3: {
                dateFormatField = DateFormat.Field.DAY_OF_MONTH;
                field = 5;
                break;
            }
            case 4: {
                dateFormatField = DateFormat.Field.HOUR_OF_DAY1;
                int hour = this.calendar.get(11);
                this.appendNumber(buffer, count, hour == 0 ? 24 : hour);
                break;
            }
            case 5: {
                dateFormatField = DateFormat.Field.HOUR_OF_DAY0;
                field = 11;
                break;
            }
            case 6: {
                dateFormatField = DateFormat.Field.MINUTE;
                field = 12;
                break;
            }
            case 7: {
                dateFormatField = DateFormat.Field.SECOND;
                field = 13;
                break;
            }
            case 8: {
                dateFormatField = DateFormat.Field.MILLISECOND;
                int value = this.calendar.get(14);
                this.appendNumber(buffer, count, value);
                break;
            }
            case 20: {
                dateFormatField = DateFormat.Field.DAY_OF_WEEK;
                this.appendDayOfWeek(buffer, count, this.formatData.longStandAloneWeekdays, this.formatData.shortStandAloneWeekdays);
                break;
            }
            case 9: {
                dateFormatField = DateFormat.Field.DAY_OF_WEEK;
                this.appendDayOfWeek(buffer, count, this.formatData.weekdays, this.formatData.shortWeekdays);
                break;
            }
            case 10: {
                dateFormatField = DateFormat.Field.DAY_OF_YEAR;
                field = 6;
                break;
            }
            case 11: {
                dateFormatField = DateFormat.Field.DAY_OF_WEEK_IN_MONTH;
                field = 8;
                break;
            }
            case 12: {
                dateFormatField = DateFormat.Field.WEEK_OF_YEAR;
                field = 3;
                break;
            }
            case 13: {
                dateFormatField = DateFormat.Field.WEEK_OF_MONTH;
                field = 4;
                break;
            }
            case 14: {
                dateFormatField = DateFormat.Field.AM_PM;
                buffer.append(this.formatData.ampms[this.calendar.get(9)]);
                break;
            }
            case 15: {
                dateFormatField = DateFormat.Field.HOUR1;
                int hour = this.calendar.get(10);
                this.appendNumber(buffer, count, hour == 0 ? 12 : hour);
                break;
            }
            case 16: {
                dateFormatField = DateFormat.Field.HOUR0;
                field = 10;
                break;
            }
            case 17: {
                dateFormatField = DateFormat.Field.TIME_ZONE;
                this.appendTimeZone(buffer, count, true);
                break;
            }
            case 18: {
                dateFormatField = DateFormat.Field.TIME_ZONE;
                this.appendNumericTimeZone(buffer, false);
            }
        }
        if (field != -1) {
            this.appendNumber(buffer, count, this.calendar.get(field));
        }
        if (fields != null) {
            position = new FieldPosition(dateFormatField);
            position.setBeginIndex(beginPosition);
            position.setEndIndex(buffer.length());
            fields.add(position);
        } else if ((position.getFieldAttribute() == dateFormatField || position.getFieldAttribute() == null && position.getField() == index) && position.getEndIndex() == 0) {
            position.setBeginIndex(beginPosition);
            position.setEndIndex(buffer.length());
        }
    }

    private void appendDayOfWeek(StringBuffer buffer, int count, String[] longs, String[] shorts) {
        boolean isLong = count > 3;
        String[] days = isLong ? longs : shorts;
        buffer.append(days[this.calendar.get(7)]);
    }

    private void appendMonth(StringBuffer buffer, int count, String[] longs, String[] shorts) {
        int month = this.calendar.get(2);
        if (count <= 2) {
            this.appendNumber(buffer, count, month + 1);
            return;
        }
        boolean isLong = count > 3;
        String[] months = isLong ? longs : shorts;
        buffer.append(months[month]);
    }

    private void appendTimeZone(StringBuffer buffer, int count, boolean generalTimeZone) {
        if (generalTimeZone) {
            int style;
            TimeZone tz = this.calendar.getTimeZone();
            boolean daylight = this.calendar.get(16) != 0;
            int n = style = count < 4 ? 0 : 1;
            if (!this.formatData.customZoneStrings) {
                buffer.append(tz.getDisplayName(daylight, style, this.formatData.locale));
                return;
            }
            String custom = TimeZones.getDisplayName(this.formatData.zoneStrings, tz.getID(), daylight, style);
            if (custom != null) {
                buffer.append(custom);
                return;
            }
        }
        this.appendNumericTimeZone(buffer, generalTimeZone);
    }

    private void appendNumericTimeZone(StringBuffer buffer, boolean generalTimeZone) {
        int offset = this.calendar.get(15) + this.calendar.get(16);
        char sign = '+';
        if (offset < 0) {
            sign = '-';
            offset = -offset;
        }
        if (generalTimeZone) {
            buffer.append("GMT");
        }
        buffer.append(sign);
        this.appendNumber(buffer, 2, offset / 3600000);
        if (generalTimeZone) {
            buffer.append(':');
        }
        this.appendNumber(buffer, 2, offset % 3600000 / 60000);
    }

    private void appendNumber(StringBuffer buffer, int count, int value) {
        int minimumIntegerDigits = this.numberFormat.getMinimumIntegerDigits();
        this.numberFormat.setMinimumIntegerDigits(count);
        this.numberFormat.format((Object)value, buffer, new FieldPosition(0));
        this.numberFormat.setMinimumIntegerDigits(minimumIntegerDigits);
    }

    private Date error(ParsePosition position, int offset, TimeZone zone) {
        position.setErrorIndex(offset);
        this.calendar.setTimeZone(zone);
        return null;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer buffer, FieldPosition fieldPos) {
        return this.formatImpl(date, buffer, fieldPos, null);
    }

    public Date get2DigitYearStart() {
        return (Date)this.defaultCenturyStart.clone();
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.pattern.hashCode() + this.formatData.hashCode() + this.creationYear;
    }

    private int parse(String string, int offset, char format, int count) {
        int index = PATTERN_CHARS.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown pattern character '" + format + "'");
        }
        int field = -1;
        int absolute = 0;
        if (count < 0) {
            absolute = count = -count;
        }
        switch (index) {
            case 0: {
                return this.parseText(string, offset, this.formatData.eras, 0);
            }
            case 1: {
                if (count >= 3) {
                    field = 1;
                    break;
                }
                ParsePosition position = new ParsePosition(offset);
                Number result = this.parseNumber(absolute, string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int year = result.intValue();
                if (position.getIndex() - offset == 2 && year >= 0 && (year += this.creationYear / 100 * 100) < this.creationYear) {
                    year += 100;
                }
                this.calendar.set(1, year);
                return position.getIndex();
            }
            case 19: {
                return this.parseMonth(string, offset, count, absolute, this.formatData.longStandAloneMonths, this.formatData.shortStandAloneMonths);
            }
            case 2: {
                return this.parseMonth(string, offset, count, absolute, this.formatData.months, this.formatData.shortMonths);
            }
            case 3: {
                field = 5;
                break;
            }
            case 4: {
                ParsePosition position = new ParsePosition(offset);
                Number result = this.parseNumber(absolute, string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int hour = result.intValue();
                if (hour == 24) {
                    hour = 0;
                }
                this.calendar.set(11, hour);
                return position.getIndex();
            }
            case 5: {
                field = 11;
                break;
            }
            case 6: {
                field = 12;
                break;
            }
            case 7: {
                field = 13;
                break;
            }
            case 8: {
                field = 14;
                break;
            }
            case 20: {
                return this.parseDayOfWeek(string, offset, this.formatData.longStandAloneWeekdays, this.formatData.shortStandAloneWeekdays);
            }
            case 9: {
                return this.parseDayOfWeek(string, offset, this.formatData.weekdays, this.formatData.shortWeekdays);
            }
            case 10: {
                field = 6;
                break;
            }
            case 11: {
                field = 8;
                break;
            }
            case 12: {
                field = 3;
                break;
            }
            case 13: {
                field = 4;
                break;
            }
            case 14: {
                return this.parseText(string, offset, this.formatData.ampms, 9);
            }
            case 15: {
                ParsePosition position = new ParsePosition(offset);
                Number result = this.parseNumber(absolute, string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int hour = result.intValue();
                if (hour == 12) {
                    hour = 0;
                }
                this.calendar.set(10, hour);
                return position.getIndex();
            }
            case 16: {
                field = 10;
                break;
            }
            case 17: {
                return this.parseTimeZone(string, offset);
            }
            case 18: {
                return this.parseTimeZone(string, offset);
            }
        }
        if (field != -1) {
            return this.parseNumber(absolute, string, offset, field, 0);
        }
        return offset;
    }

    private int parseDayOfWeek(String string, int offset, String[] longs, String[] shorts) {
        int index = this.parseText(string, offset, longs, 7);
        if (index < 0) {
            index = this.parseText(string, offset, shorts, 7);
        }
        return index;
    }

    private int parseMonth(String string, int offset, int count, int absolute, String[] longs, String[] shorts) {
        if (count <= 2) {
            return this.parseNumber(absolute, string, offset, 2, -1);
        }
        int index = this.parseText(string, offset, longs, 2);
        if (index < 0) {
            index = this.parseText(string, offset, shorts, 2);
        }
        return index;
    }

    @Override
    public Date parse(String string, ParsePosition position) {
        Date date;
        boolean quote = false;
        int last = -1;
        int count = 0;
        int offset = position.getIndex();
        int length = string.length();
        this.calendar.clear();
        TimeZone zone = this.calendar.getTimeZone();
        int patternLength = this.pattern.length();
        for (int i = 0; i < patternLength; ++i) {
            int next = this.pattern.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    if ((offset = this.parse(string, offset, (char)last, count)) < 0) {
                        return this.error(position, -offset - 1, zone);
                    }
                    count = 0;
                }
                if (last == next) {
                    if (offset >= length || string.charAt(offset) != '\'') {
                        return this.error(position, offset, zone);
                    }
                    ++offset;
                    last = -1;
                } else {
                    last = next;
                }
                quote = !quote;
                continue;
            }
            if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                    continue;
                }
                if (count > 0 && (offset = this.parse(string, offset, (char)last, -count)) < 0) {
                    return this.error(position, -offset - 1, zone);
                }
                last = next;
                count = 1;
                continue;
            }
            if (count > 0) {
                if ((offset = this.parse(string, offset, (char)last, count)) < 0) {
                    return this.error(position, -offset - 1, zone);
                }
                count = 0;
            }
            last = -1;
            if (offset >= length || string.charAt(offset) != next) {
                return this.error(position, offset, zone);
            }
            ++offset;
        }
        if (count > 0 && (offset = this.parse(string, offset, (char)last, count)) < 0) {
            return this.error(position, -offset - 1, zone);
        }
        try {
            date = this.calendar.getTime();
        }
        catch (IllegalArgumentException e) {
            return this.error(position, offset, zone);
        }
        position.setIndex(offset);
        this.calendar.setTimeZone(zone);
        return date;
    }

    private Number parseNumber(int max, String string, ParsePosition position) {
        int digit;
        int length = string.length();
        int result = 0;
        int index = position.getIndex();
        if (max > 0 && max < length - index) {
            length = index + max;
        }
        while (index < length && (string.charAt(index) == ' ' || string.charAt(index) == '\t')) {
            ++index;
        }
        if (max == 0) {
            position.setIndex(index);
            return this.numberFormat.parse(string, position);
        }
        while (index < length && (digit = Character.digit(string.charAt(index), 10)) != -1) {
            ++index;
            result = result * 10 + digit;
        }
        if (index == position.getIndex()) {
            position.setErrorIndex(index);
            return null;
        }
        position.setIndex(index);
        return result;
    }

    private int parseNumber(int max, String string, int offset, int field, int skew) {
        ParsePosition position = new ParsePosition(offset);
        Number result = this.parseNumber(max, string, position);
        if (result == null) {
            return -position.getErrorIndex() - 1;
        }
        this.calendar.set(field, result.intValue() + skew);
        return position.getIndex();
    }

    private int parseText(String string, int offset, String[] text, int field) {
        int found = -1;
        for (int i = 0; i < text.length; ++i) {
            if (text[i].isEmpty() || !string.regionMatches(true, offset, text[i], 0, text[i].length()) || found != -1 && text[i].length() <= text[found].length()) continue;
            found = i;
        }
        if (found != -1) {
            this.calendar.set(field, found);
            return offset + text[found].length();
        }
        return -offset - 1;
    }

    private int parseTimeZone(String string, int offset) {
        String[][] zones;
        char sign;
        boolean foundGMT = string.regionMatches(offset, "GMT", 0, 3);
        if (foundGMT) {
            offset += 3;
        }
        if (offset < string.length() && ((sign = string.charAt(offset)) == '+' || sign == '-')) {
            ParsePosition position = new ParsePosition(offset + 1);
            Number result = this.numberFormat.parse(string, position);
            if (result == null) {
                return -position.getErrorIndex() - 1;
            }
            int hour = result.intValue();
            int raw = hour * 3600000;
            int index = position.getIndex();
            if (index < string.length() && string.charAt(index) == ':') {
                position.setIndex(index + 1);
                result = this.numberFormat.parse(string, position);
                if (result == null) {
                    return -position.getErrorIndex() - 1;
                }
                int minute = result.intValue();
                raw += minute * 60000;
            } else if (hour >= 24) {
                raw = hour / 100 * 3600000 + hour % 100 * 60000;
            }
            if (sign == '-') {
                raw = -raw;
            }
            this.calendar.setTimeZone(new SimpleTimeZone(raw, ""));
            return position.getIndex();
        }
        if (foundGMT) {
            this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            return offset;
        }
        for (String[] element : zones = this.formatData.internalZoneStrings()) {
            for (int j = 1; j < 5; ++j) {
                if (!string.regionMatches(true, offset, element[j], 0, element[j].length())) continue;
                TimeZone zone = TimeZone.getTimeZone(element[0]);
                if (zone == null) {
                    return -offset - 1;
                }
                int raw = zone.getRawOffset();
                if (j == 3 || j == 4) {
                    raw += 3600000;
                }
                this.calendar.setTimeZone(new SimpleTimeZone(raw, ""));
                return offset + element[j].length();
            }
        }
        return -offset - 1;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = (Date)date.clone();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.defaultCenturyStart);
        this.creationYear = cal.get(1);
    }

    public void setDateFormatSymbols(DateFormatSymbols value) {
        this.formatData = (DateFormatSymbols)value.clone();
    }

    public String toLocalizedPattern() {
        return SimpleDateFormat.convertPattern(this.pattern, PATTERN_CHARS, this.formatData.getLocalPatternChars(), false);
    }

    private static String convertPattern(String template, String fromChars, String toChars, boolean check) {
        if (!check && fromChars.equals(toChars)) {
            return template;
        }
        boolean quote = false;
        StringBuilder output = new StringBuilder();
        int length = template.length();
        for (int i = 0; i < length; ++i) {
            int index;
            char next = template.charAt(i);
            if (next == '\'') {
                boolean bl = quote = !quote;
            }
            if (!quote && (index = fromChars.indexOf(next)) != -1) {
                output.append(toChars.charAt(index));
                continue;
            }
            if (check && !quote && (next >= 'a' && next <= 'z' || next >= 'A' && next <= 'Z')) {
                throw new IllegalArgumentException("Invalid pattern character '" + next + "' in " + "'" + template + "'");
            }
            output.append(next);
        }
        if (quote) {
            throw new IllegalArgumentException("Unterminated quote");
        }
        return output.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("defaultCenturyStart", this.defaultCenturyStart);
        fields.put("formatData", this.formatData);
        fields.put("pattern", this.pattern);
        fields.put("serialVersionOnStream", 1);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        int version = fields.get("serialVersionOnStream", 0);
        Date date = version > 0 ? (Date)fields.get("defaultCenturyStart", new Date()) : new Date();
        this.set2DigitYearStart(date);
        this.formatData = (DateFormatSymbols)fields.get("formatData", null);
        this.pattern = (String)fields.get("pattern", "");
    }
}

