/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    private static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };
    private static final Enumeration<?> EMPTY_ENUMERATION = new Enumeration<Object>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    public static final List EMPTY_LIST = new EmptyList();
    public static final Set EMPTY_SET = new EmptySet();
    public static final Map EMPTY_MAP = new EmptyMap();

    private Collections() {
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T object) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list.isEmpty()) {
            return -1;
        }
        if (!(list instanceof RandomAccess)) {
            ListIterator<Comparable<T>> it = list.listIterator();
            while (it.hasNext()) {
                int result = -it.next().compareTo(object);
                if (result > 0) continue;
                if (result == 0) {
                    return it.previousIndex();
                }
                return -it.previousIndex() - 1;
            }
            return -list.size() - 1;
        }
        int low = 0;
        int mid = list.size();
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            result = -list.get(mid).compareTo(object);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    public static <T> int binarySearch(List<? extends T> list, T object, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, object);
        }
        if (!(list instanceof RandomAccess)) {
            ListIterator<T> it = list.listIterator();
            while (it.hasNext()) {
                int result = -comparator.compare(it.next(), object);
                if (result > 0) continue;
                if (result == 0) {
                    return it.previousIndex();
                }
                return -it.previousIndex() - 1;
            }
            return -list.size() - 1;
        }
        int low = 0;
        int mid = list.size();
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            result = -comparator.compare(list.get(mid), object);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    public static <T> void copy(List<? super T> destination, List<? extends T> source) {
        if (destination.size() < source.size()) {
            throw new IndexOutOfBoundsException("destination.size() < source.size(): " + destination.size() + " < " + source.size());
        }
        Iterator<T> srcIt = source.iterator();
        ListIterator<T> destIt = destination.listIterator();
        while (srcIt.hasNext()) {
            try {
                destIt.next();
            }
            catch (NoSuchElementException e) {
                throw new IndexOutOfBoundsException("Source size " + source.size() + " does not fit into destination");
            }
            destIt.set(srcIt.next());
        }
    }

    public static <T> Enumeration<T> enumeration(Collection<T> collection) {
        final Collection<T> c = collection;
        return new Enumeration<T>(){
            Iterator<T> it;
            {
                this.it = c.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public T nextElement() {
                return this.it.next();
            }
        };
    }

    public static <T> void fill(List<? super T> list, T object) {
        ListIterator<T> it = list.listIterator();
        while (it.hasNext()) {
            it.next();
            it.set(object);
        }
    }

    public static <T> T max(Collection<? extends T> collection) {
        Iterator<T> it = collection.iterator();
        T max = it.next();
        while (it.hasNext()) {
            T next = it.next();
            if (((Comparable)max).compareTo(next) >= 0) continue;
            max = next;
        }
        return max;
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            T result = Collections.max(collection);
            return result;
        }
        Iterator<T> it = collection.iterator();
        T max = it.next();
        while (it.hasNext()) {
            T next = it.next();
            if (comparator.compare(max, next) >= 0) continue;
            max = next;
        }
        return max;
    }

    public static <T> T min(Collection<? extends T> collection) {
        Iterator<T> it = collection.iterator();
        T min = it.next();
        while (it.hasNext()) {
            T next = it.next();
            if (((Comparable)min).compareTo(next) <= 0) continue;
            min = next;
        }
        return min;
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            T result = Collections.min(collection);
            return result;
        }
        Iterator<T> it = collection.iterator();
        T min = it.next();
        while (it.hasNext()) {
            T next = it.next();
            if (comparator.compare(min, next) <= 0) continue;
            min = next;
        }
        return min;
    }

    public static <T> List<T> nCopies(int length, T object) {
        return new CopiesList<T>(length, object);
    }

    public static void reverse(List<?> list) {
        int size = list.size();
        ListIterator<?> front = list.listIterator();
        ListIterator<?> back = list.listIterator(size);
        for (int i = 0; i < size / 2; ++i) {
            Object frontNext = front.next();
            Object backPrev = back.previous();
            front.set(backPrev);
            back.set(frontNext);
        }
    }

    public static <T> Comparator<T> reverseOrder() {
        return ReverseComparator.INSTANCE;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> c) {
        if (c == null) {
            return Collections.reverseOrder();
        }
        if (c instanceof ReverseComparator2) {
            return ((ReverseComparator2)c).cmp;
        }
        return new ReverseComparator2<T>(c);
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list, new Random());
    }

    public static void shuffle(List<?> list, Random random) {
        List<?> objectList = list;
        if (list instanceof RandomAccess) {
            for (int i = objectList.size() - 1; i > 0; --i) {
                int index = random.nextInt(i + 1);
                objectList.set(index, objectList.set(i, objectList.get(index)));
            }
        } else {
            int i;
            Object[] array = objectList.toArray();
            for (i = array.length - 1; i > 0; --i) {
                int index = random.nextInt(i + 1);
                Object temp = array[i];
                array[i] = array[index];
                array[index] = temp;
            }
            i = 0;
            ListIterator<?> it = objectList.listIterator();
            while (it.hasNext()) {
                it.next();
                it.set(array[i++]);
            }
        }
    }

    public static <E> Set<E> singleton(E object) {
        return new SingletonSet<E>(object);
    }

    public static <E> List<E> singletonList(E object) {
        return new SingletonList<E>(object);
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        return new SingletonMap<K, V>(key, value);
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        Object[] array = list.toArray();
        Arrays.sort(array);
        int i = 0;
        ListIterator<T> it = list.listIterator();
        while (it.hasNext()) {
            it.next();
            it.set((Comparable)array[i++]);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        Object[] array = list.toArray(new Object[list.size()]);
        Arrays.sort(array, comparator);
        int i = 0;
        ListIterator<T> it = list.listIterator();
        while (it.hasNext()) {
            it.next();
            it.set(array[i++]);
        }
    }

    public static void swap(List<?> list, int index1, int index2) {
        if (list == null) {
            throw new NullPointerException();
        }
        int size = list.size();
        if (index1 < 0 || index1 >= size || index2 < 0 || index2 >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (index1 == index2) {
            return;
        }
        List<?> rawList = list;
        rawList.set(index2, rawList.set(index1, rawList.get(index2)));
    }

    public static <T> boolean replaceAll(List<T> list, T obj, T obj2) {
        int index;
        boolean found = false;
        while ((index = list.indexOf(obj)) > -1) {
            found = true;
            list.set(index, obj2);
        }
        return found;
    }

    public static void rotate(List<?> lst, int dist) {
        List<?> list = lst;
        int size = list.size();
        if (size == 0) {
            return;
        }
        int normdist = dist > 0 ? dist % size : size - dist % size * -1;
        if (normdist == 0 || normdist == size) {
            return;
        }
        if (list instanceof RandomAccess) {
            Object temp = list.get(0);
            int index = 0;
            int beginIndex = 0;
            for (int i = 0; i < size; ++i) {
                index = (index + normdist) % size;
                temp = list.set(index, temp);
                if (index != beginIndex) continue;
                index = ++beginIndex;
                temp = list.get(beginIndex);
            }
        } else {
            int divideIndex = (size - normdist) % size;
            List<?> sublist1 = list.subList(0, divideIndex);
            List<?> sublist2 = list.subList(divideIndex, size);
            Collections.reverse(sublist1);
            Collections.reverse(sublist2);
            Collections.reverse(list);
        }
    }

    public static int indexOfSubList(List<?> list, List<?> sublist) {
        int size = list.size();
        int sublistSize = sublist.size();
        if (sublistSize > size) {
            return -1;
        }
        if (sublistSize == 0) {
            return 0;
        }
        Object firstObj = sublist.get(0);
        int index = list.indexOf(firstObj);
        if (index == -1) {
            return -1;
        }
        while (index < size && size - index >= sublistSize) {
            ListIterator<?> listIt = list.listIterator(index);
            if (firstObj == null ? listIt.next() == null : firstObj.equals(listIt.next())) {
                ListIterator<?> sublistIt = sublist.listIterator(1);
                boolean difFound = false;
                while (sublistIt.hasNext()) {
                    Object element = sublistIt.next();
                    if (!listIt.hasNext()) {
                        return -1;
                    }
                    if (!(element == null ? listIt.next() != null : !element.equals(listIt.next()))) continue;
                    difFound = true;
                    break;
                }
                if (!difFound) {
                    return index;
                }
            }
            ++index;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> list, List<?> sublist) {
        int size;
        int sublistSize = sublist.size();
        if (sublistSize > (size = list.size())) {
            return -1;
        }
        if (sublistSize == 0) {
            return size;
        }
        Object lastObj = sublist.get(sublistSize - 1);
        for (int index = list.lastIndexOf(lastObj); index > -1 && index + 1 >= sublistSize; --index) {
            ListIterator<?> listIt = list.listIterator(index + 1);
            if (!(lastObj == null ? listIt.previous() == null : lastObj.equals(listIt.previous()))) continue;
            ListIterator<?> sublistIt = sublist.listIterator(sublistSize - 1);
            boolean difFound = false;
            while (sublistIt.hasPrevious()) {
                Object element = sublistIt.previous();
                if (!listIt.hasPrevious()) {
                    return -1;
                }
                if (!(element == null ? listIt.previous() != null : !element.equals(listIt.previous()))) continue;
                difFound = true;
                break;
            }
            if (difFound) continue;
            return listIt.nextIndex();
        }
        return -1;
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        ArrayList<T> list = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        return new SynchronizedCollection<T>(collection);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new SynchronizedRandomAccessList<T>(list);
        }
        return new SynchronizedList<T>(list);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new SynchronizedMap<K, V>(map);
    }

    public static <E> Set<E> synchronizedSet(Set<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSet<E>(set);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSortedMap<K, V>(map);
    }

    public static <E> SortedSet<E> synchronizedSortedSet(SortedSet<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new SynchronizedSortedSet<E>(set);
    }

    public static <E> Collection<E> unmodifiableCollection(Collection<? extends E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableCollection<E>(collection);
    }

    public static <E> List<E> unmodifiableList(List<? extends E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList<E>(list);
        }
        return new UnmodifiableList<E>(list);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableMap<K, V>(map);
    }

    public static <E> Set<E> unmodifiableSet(Set<? extends E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSet<E>(set);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSortedMap<K, V>(map);
    }

    public static <E> SortedSet<E> unmodifiableSortedSet(SortedSet<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSortedSet<E>(set);
    }

    public static int frequency(Collection<?> c, Object o) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (Object e : c) {
            if (!(o == null ? e == null : o.equals(e))) continue;
            ++result;
        }
        return result;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> Enumeration<T> emptyEnumeration() {
        return EMPTY_ENUMERATION;
    }

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return Collections.emptyList().listIterator();
    }

    public static <E> Collection<E> checkedCollection(Collection<E> c, Class<E> type) {
        return new CheckedCollection<E>(c, type);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> m, Class<K> keyType, Class<V> valueType) {
        return new CheckedMap(m, keyType, valueType);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> type) {
        if (list instanceof RandomAccess) {
            return new CheckedRandomAccessList<E>(list, type);
        }
        return new CheckedList<E>(list, type);
    }

    public static <E> Set<E> checkedSet(Set<E> s, Class<E> type) {
        return new CheckedSet<E>(s, type);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> m, Class<K> keyType, Class<V> valueType) {
        return new CheckedSortedMap<K, V>(m, keyType, valueType);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> s, Class<E> type) {
        return new CheckedSortedSet<E>(s, type);
    }

    public static <T> boolean addAll(Collection<? super T> c, T ... a) {
        boolean modified = false;
        for (int i = 0; i < a.length; ++i) {
            modified |= c.add(a[i]);
        }
        return modified;
    }

    public static boolean disjoint(Collection<?> c1, Collection<?> c2) {
        if (c1 instanceof Set && !(c2 instanceof Set) || c2.size() > c1.size()) {
            Collection<?> tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        Iterator<?> it = c1.iterator();
        while (it.hasNext()) {
            if (!c2.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    static <E> E checkType(E obj, Class<? extends E> type) {
        if (obj != null && !type.isInstance(obj)) {
            throw new ClassCastException("Attempt to insert element of type " + obj.getClass() + " into collection of type " + type);
        }
        return obj;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        if (map.isEmpty()) {
            return new SetFromMap<E>(map);
        }
        throw new IllegalArgumentException();
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new AsLIFOQueue<T>(deque);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 1599671320688067438L;
        SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> m, Class<K> keyType, Class<V> valueType) {
            super(m, keyType, valueType);
            this.sm = m;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new CheckedSortedMap<K, V>(this.sm.subMap(fromKey, toKey), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new CheckedSortedMap<K, V>(this.sm.headMap(toKey), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new CheckedSortedMap<K, V>(this.sm.tailMap(fromKey), this.keyType, this.valueType);
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 1599911165492914959L;
        private SortedSet<E> ss;

        public CheckedSortedSet(SortedSet<E> s, Class<E> type) {
            super(s, type);
            this.ss = s;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new CheckedSortedSet<E>(this.ss.subSet(fromElement, toElement), this.type);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new CheckedSortedSet<E>(this.ss.headSet(toElement), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new CheckedSortedSet<E>(this.ss.tailSet(fromElement), this.type);
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        Map<K, V> m;
        Class<K> keyType;
        Class<V> valueType;

        private CheckedMap(Map<K, V> m, Class<K> keyType, Class<V> valueType) {
            if (m == null || keyType == null || valueType == null) {
                throw new NullPointerException();
            }
            this.m = m;
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.m.put(Collections.checkType(key, this.keyType), Collections.checkType(value, this.valueType));
        }

        @Override
        public V remove(Object key) {
            return this.m.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            int i;
            int size = map.size();
            if (size == 0) {
                return;
            }
            Map.Entry[] entries = new Map.Entry[size];
            Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
            for (i = 0; i < size; ++i) {
                Map.Entry<K, V> e = it.next();
                Collections.checkType(e.getKey(), this.keyType);
                Collections.checkType(e.getValue(), this.valueType);
                entries[i] = e;
            }
            for (i = 0; i < size; ++i) {
                this.m.put(entries[i].getKey(), entries[i].getValue());
            }
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.m.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new CheckedEntrySet<K, V>(this.m.entrySet(), this.valueType);
        }

        @Override
        public boolean equals(Object obj) {
            return ((Object)this.m).equals(obj);
        }

        @Override
        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            Set<Map.Entry<K, V>> s;
            Class<V> valueType;

            public CheckedEntrySet(Set<Map.Entry<K, V>> s, Class<V> valueType) {
                this.s = s;
                this.valueType = valueType;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CheckedEntryIterator<K, V>(this.s.iterator(), this.valueType);
            }

            @Override
            public Object[] toArray() {
                int thisSize = this.size();
                Object[] array = new Object[thisSize];
                Iterator<Map.Entry<K, V>> it = this.iterator();
                for (int i = 0; i < thisSize; ++i) {
                    array[i] = it.next();
                }
                return array;
            }

            @Override
            public <T> T[] toArray(T[] array) {
                int thisSize = this.size();
                if (array.length < thisSize) {
                    Class<?> ct = array.getClass().getComponentType();
                    array = (Object[])Array.newInstance(ct, thisSize);
                }
                Iterator<Map.Entry<K, V>> it = this.iterator();
                for (int i = 0; i < thisSize; ++i) {
                    array[i] = it.next();
                }
                if (thisSize < array.length) {
                    array[thisSize] = null;
                }
                return array;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.s.retainAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.s.removeAll(c);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.s.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                return this.s.remove(o);
            }

            @Override
            public boolean contains(Object o) {
                return this.s.contains(o);
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public int hashCode() {
                return ((Object)this.s).hashCode();
            }

            @Override
            public boolean equals(Object object) {
                return ((Object)this.s).equals(object);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class CheckedEntryIterator<K, V>
            implements Iterator<Map.Entry<K, V>> {
                Iterator<Map.Entry<K, V>> i;
                Class<V> valueType;

                public CheckedEntryIterator(Iterator<Map.Entry<K, V>> i, Class<V> valueType) {
                    this.i = i;
                    this.valueType = valueType;
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }

                @Override
                public Map.Entry<K, V> next() {
                    return new CheckedEntry<K, V>(this.i.next(), this.valueType);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CheckedEntry<K, V>
        implements Map.Entry<K, V> {
            Map.Entry<K, V> e;
            Class<V> valueType;

            public CheckedEntry(Map.Entry<K, V> e, Class<V> valueType) {
                if (e == null) {
                    throw new NullPointerException();
                }
                this.e = e;
                this.valueType = valueType;
            }

            @Override
            public K getKey() {
                return this.e.getKey();
            }

            @Override
            public V getValue() {
                return this.e.getValue();
            }

            @Override
            public V setValue(V obj) {
                return this.e.setValue(Collections.checkType(obj, this.valueType));
            }

            @Override
            public boolean equals(Object obj) {
                return ((Object)this.e).equals(obj);
            }

            @Override
            public int hashCode() {
                return ((Object)this.e).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 4694047833775013803L;

        public CheckedSet(Set<E> s, Class<E> type) {
            super(s, type);
        }

        @Override
        public boolean equals(Object obj) {
            return ((Object)this.c).equals(obj);
        }

        @Override
        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        public CheckedRandomAccessList(List<E> l, Class<E> type) {
            super(l, type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        List<E> l;

        public CheckedList(List<E> l, Class<E> type) {
            super(l, type);
            this.l = l;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c1) {
            Object[] array;
            for (Object o : array = c1.toArray()) {
                Collections.checkType(o, this.type);
            }
            return this.l.addAll(index, Arrays.asList(array));
        }

        @Override
        public E get(int index) {
            return this.l.get(index);
        }

        @Override
        public E set(int index, E obj) {
            return this.l.set(index, Collections.checkType(obj, this.type));
        }

        @Override
        public void add(int index, E obj) {
            this.l.add(index, Collections.checkType(obj, this.type));
        }

        @Override
        public E remove(int index) {
            return this.l.remove(index);
        }

        @Override
        public int indexOf(Object obj) {
            return this.l.indexOf(obj);
        }

        @Override
        public int lastIndexOf(Object obj) {
            return this.l.lastIndexOf(obj);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new CheckedListIterator<E>(this.l.listIterator(), this.type);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new CheckedListIterator<E>(this.l.listIterator(index), this.type);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return Collections.checkedList(this.l.subList(fromIndex, toIndex), this.type);
        }

        @Override
        public boolean equals(Object obj) {
            return ((Object)this.l).equals(obj);
        }

        @Override
        public int hashCode() {
            return ((Object)this.l).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedListIterator<E>
    implements ListIterator<E> {
        private ListIterator<E> i;
        private Class<E> type;

        public CheckedListIterator(ListIterator<E> i, Class<E> type) {
            this.i = i;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public E next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public E previous() {
            return this.i.previous();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(E obj) {
            this.i.set(Collections.checkType(obj, this.type));
        }

        @Override
        public void add(E obj) {
            this.i.add(Collections.checkType(obj, this.type));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        Collection<E> c;
        Class<E> type;

        public CheckedCollection(Collection<E> c, Class<E> type) {
            if (c == null || type == null) {
                throw new NullPointerException();
            }
            this.c = c;
            this.type = type;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object obj) {
            return this.c.contains(obj);
        }

        @Override
        public Iterator<E> iterator() {
            Iterator<E> i = this.c.iterator();
            if (i instanceof ListIterator) {
                i = new CheckedListIterator<E>((ListIterator)i, this.type);
            }
            return i;
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] arr) {
            return this.c.toArray(arr);
        }

        @Override
        public boolean add(E obj) {
            return this.c.add(Collections.checkType(obj, this.type));
        }

        @Override
        public boolean remove(Object obj) {
            return this.c.remove(obj);
        }

        @Override
        public boolean containsAll(Collection<?> c1) {
            return this.c.containsAll(c1);
        }

        @Override
        public boolean addAll(Collection<? extends E> c1) {
            Object[] array;
            for (Object o : array = c1.toArray()) {
                Collections.checkType(o, this.type);
            }
            return this.c.addAll(Arrays.asList(array));
        }

        @Override
        public boolean removeAll(Collection<?> c1) {
            return this.c.removeAll(c1);
        }

        @Override
        public boolean retainAll(Collection<?> c1) {
            return this.c.retainAll(c1);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        public String toString() {
            return this.c.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AsLIFOQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque<E> q;

        AsLIFOQueue(Deque<E> deque) {
            this.q = deque;
        }

        @Override
        public Iterator<E> iterator() {
            return this.q.iterator();
        }

        @Override
        public int size() {
            return this.q.size();
        }

        @Override
        public boolean offer(E o) {
            return this.q.offerFirst(o);
        }

        @Override
        public E peek() {
            return this.q.peekFirst();
        }

        @Override
        public E poll() {
            return this.q.pollFirst();
        }

        @Override
        public boolean add(E o) {
            this.q.push(o);
            return true;
        }

        @Override
        public void clear() {
            this.q.clear();
        }

        @Override
        public E element() {
            return this.q.getFirst();
        }

        @Override
        public E remove() {
            return this.q.pop();
        }

        @Override
        public boolean contains(Object object) {
            return this.q.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.q.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            return this.q.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.q.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.q.retainAll(collection);
        }

        @Override
        public Object[] toArray() {
            return this.q.toArray();
        }

        @Override
        public <T> T[] toArray(T[] contents) {
            return this.q.toArray(contents);
        }

        @Override
        public String toString() {
            return this.q.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 2454657854757543876L;
        private Map<E, Boolean> m;
        private transient Set<E> backingSet;

        SetFromMap(Map<E, Boolean> map) {
            this.m = map;
            this.backingSet = map.keySet();
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.backingSet).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.backingSet).hashCode();
        }

        @Override
        public boolean add(E object) {
            return this.m.put(object, Boolean.TRUE) == null;
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public String toString() {
            return this.backingSet.toString();
        }

        @Override
        public boolean contains(Object object) {
            return this.backingSet.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.backingSet.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            return this.m.remove(object) != null;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.backingSet.retainAll(collection);
        }

        @Override
        public Object[] toArray() {
            return this.backingSet.toArray();
        }

        @Override
        public <T> T[] toArray(T[] contents) {
            return this.backingSet.toArray(contents);
        }

        @Override
        public Iterator<E> iterator() {
            return this.backingSet.iterator();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.backingSet = this.m.keySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> set) {
            super(set);
            this.ss = set;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public SortedSet<E> headSet(E before) {
            return new UnmodifiableSortedSet<E>(this.ss.headSet(before));
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E start, E end) {
            return new UnmodifiableSortedSet<E>(this.ss.subSet(start, end));
        }

        @Override
        public SortedSet<E> tailSet(E after) {
            return new UnmodifiableSortedSet<E>(this.ss.tailSet(after));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, V> sm;

        UnmodifiableSortedMap(SortedMap<K, V> map) {
            super(map);
            this.sm = map;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K before) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(before));
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K start, K end) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(start, end));
        }

        @Override
        public SortedMap<K, V> tailMap(K after) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(after));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<E> set) {
            super(set);
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.c).equals(object);
        }

        @Override
        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<K, V> m;

        UnmodifiableMap(Map<K, V> map) {
            this.m = map;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new UnmodifiableEntrySet<K, V>(this.m.entrySet());
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.m).equals(object);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public int hashCode() {
            return ((Object)this.m).hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            return new UnmodifiableSet<K>(this.m.keySet());
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public Collection<V> values() {
            return new UnmodifiableCollection<V>(this.m.values());
        }

        public String toString() {
            return this.m.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<Map.Entry<K, V>> set) {
                super(set);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> iterator;
                    {
                        this.iterator = UnmodifiableEntrySet.this.c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableMapEntry(this.iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                int length = this.c.size();
                Object[] result = new Object[length];
                Iterator<Map.Entry<K, V>> it = this.iterator();
                int i = length;
                while (--i >= 0) {
                    result[i] = it.next();
                }
                return result;
            }

            @Override
            public <T> T[] toArray(T[] contents) {
                int size = this.c.size();
                int index = 0;
                Iterator<Map.Entry<K, V>> it = this.iterator();
                if (size > contents.length) {
                    Class<?> ct = contents.getClass().getComponentType();
                    contents = (Object[])Array.newInstance(ct, size);
                }
                while (index < size) {
                    contents[index++] = it.next();
                }
                if (index < contents.length) {
                    contents[index] = null;
                }
                return contents;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class UnmodifiableMapEntry<K, V>
            implements Map.Entry<K, V> {
                Map.Entry<K, V> mapEntry;

                UnmodifiableMapEntry(Map.Entry<K, V> entry) {
                    this.mapEntry = entry;
                }

                @Override
                public boolean equals(Object object) {
                    return ((Object)this.mapEntry).equals(object);
                }

                @Override
                public K getKey() {
                    return this.mapEntry.getKey();
                }

                @Override
                public V getValue() {
                    return this.mapEntry.getValue();
                }

                @Override
                public int hashCode() {
                    return ((Object)this.mapEntry).hashCode();
                }

                @Override
                public V setValue(V object) {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return this.mapEntry.toString();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<E> list;

        UnmodifiableList(List<E> l) {
            super(l);
            this.list = l;
        }

        @Override
        public void add(int location, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int location, Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.list).equals(object);
        }

        @Override
        public E get(int location) {
            return this.list.get(location);
        }

        @Override
        public int hashCode() {
            return ((Object)this.list).hashCode();
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int location) {
            return new ListIterator<E>(){
                ListIterator<E> iterator;
                {
                    this.iterator = UnmodifiableList.this.list.listIterator(location);
                }

                @Override
                public void add(E object) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.iterator.hasPrevious();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public int nextIndex() {
                    return this.iterator.nextIndex();
                }

                @Override
                public E previous() {
                    return this.iterator.previous();
                }

                @Override
                public int previousIndex() {
                    return this.iterator.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E object) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public E remove(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int location, E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<E> subList(int start, int end) {
            return new UnmodifiableList<E>(this.list.subList(start, end));
        }

        private Object readResolve() {
            if (this.list instanceof RandomAccess) {
                return new UnmodifiableRandomAccessList<E>(this.list);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<E> l) {
            super(l);
        }

        @Override
        public List<E> subList(int start, int end) {
            return new UnmodifiableRandomAccessList(this.list.subList(start, end));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<E> c;

        UnmodifiableCollection(Collection<E> collection) {
            this.c = collection;
        }

        @Override
        public boolean add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                Iterator<E> iterator;
                {
                    this.iterator = UnmodifiableCollection.this.c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public E next() {
                    return this.iterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.c.toArray(array);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> set) {
            super(set);
            this.ss = set;
        }

        SynchronizedSortedSet(SortedSet<E> set, Object mutex) {
            super(set, mutex);
            this.ss = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.headSet(end), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E start, E end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.subSet(start, end), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E start) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.tailSet(start), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> map) {
            super(map);
            this.sm = map;
        }

        SynchronizedSortedMap(SortedMap<K, V> map, Object mutex) {
            super(map, mutex);
            this.sm = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K endKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.headMap(endKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K startKey, K endKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.subMap(startKey, endKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K startKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.tailMap(startKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> set) {
            super(set);
        }

        SynchronizedSet(Set<E> set, Object mutex) {
            super(set, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.c).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.c).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;

        SynchronizedMap(Map<K, V> map) {
            this.m = map;
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> map, Object mutex) {
            this.m = map;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSet<Map.Entry<K, V>>(this.m.entrySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.m).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.m).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSet<K>(this.m.keySet(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedCollection<V>(this.m.values(), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> l) {
            super(l);
            this.list = l;
        }

        SynchronizedList(List<E> l, Object mutex) {
            super(l, mutex);
            this.list = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int location, E object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.list.add(location, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int location, Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(location, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return ((Object)this.list).equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int location) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(location);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return ((Object)this.list).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object[] array;
            int size;
            Object object2 = this.mutex;
            synchronized (object2) {
                size = this.list.size();
                array = new Object[size];
                this.list.toArray(array);
            }
            if (object != null) {
                for (int i = 0; i < size; ++i) {
                    if (!object.equals(array[i])) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (array[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object[] array;
            Object object2 = this.mutex;
            synchronized (object2) {
                int size = this.list.size();
                array = new Object[size];
                this.list.toArray(array);
            }
            if (object != null) {
                for (int i = size - 1; i >= 0; --i) {
                    if (!object.equals(array[i])) continue;
                    return i;
                }
            } else {
                for (int i = size - 1; i >= 0; --i) {
                    if (array[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.listIterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int location) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.listIterator(location);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int location) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(location);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int location, E object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.set(location, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int start, int end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<E>(this.list.subList(start, end), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }

        private Object readResolve() {
            if (this.list instanceof RandomAccess) {
                return new SynchronizedRandomAccessList<E>(this.list, this.mutex);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> l) {
            super(l);
        }

        SynchronizedRandomAccessList(List<E> l, Object mutex) {
            super(l, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int start, int end) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(start, end), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> collection) {
            this.c = collection;
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> collection, Object mutex) {
            this.c = collection;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] array) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream stream) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                stream.defaultWriteObject();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        final K k;
        final V v;

        SingletonMap(K key, V value) {
            this.k = key;
            this.v = value;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.k == null ? key == null : this.k.equals(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.v == null ? value == null : this.v.equals(value);
        }

        @Override
        public V get(Object key) {
            if (this.containsKey(key)) {
                return this.v;
            }
            return null;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        return SingletonMap.this.containsKey(entry.getKey()) && SingletonMap.this.containsValue(entry.getValue());
                    }
                    return false;
                }

                @Override
                public int size() {
                    return 1;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        boolean hasNext = true;

                        @Override
                        public boolean hasNext() {
                            return this.hasNext;
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            if (!this.hasNext) {
                                throw new NoSuchElementException();
                            }
                            this.hasNext = false;
                            return new MapEntry<K, V>(SingletonMap.this.k, SingletonMap.this.v){

                                @Override
                                public V setValue(V value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonList<E>
    extends AbstractList<E>
    implements Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        final E element;

        SingletonList(E object) {
            this.element = object;
        }

        @Override
        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        @Override
        public E get(int location) {
            if (location == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final E element;

        SingletonSet(E object) {
            this.element = object;
        }

        @Override
        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public E next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseComparator2<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        private final Comparator<T> cmp;

        ReverseComparator2(Comparator<T> comparator) {
            this.cmp = comparator;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.cmp.compare(o2, o1);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ReverseComparator2 && ((Object)((ReverseComparator2)o).cmp).equals(this.cmp);
        }

        public int hashCode() {
            return ~this.cmp.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final ReverseComparator<Object> INSTANCE = new ReverseComparator();
        private static final long serialVersionUID = 7207038068494060240L;

        private ReverseComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            Comparable c2 = (Comparable)o2;
            return c2.compareTo(o1);
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public Object get(Object key) {
            return null;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Collection values() {
            return EMPTY_LIST;
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        public boolean contains(Object object) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        public boolean contains(Object object) {
            return false;
        }

        public int size() {
            return 0;
        }

        public Object get(int location) {
            throw new IndexOutOfBoundsException();
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CopiesList<E>
    extends AbstractList<E>
    implements Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final E element;

        CopiesList(int length, E object) {
            if (length < 0) {
                throw new IllegalArgumentException();
            }
            this.n = length;
            this.element = object;
        }

        @Override
        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public E get(int location) {
            if (location >= 0 && location < this.n) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

