/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import libcore.icu.ICU;
import libcore.icu.LocaleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private static final HashMap<String, Currency> codesToCurrencies = new HashMap();
    private static final HashMap<Locale, Currency> localesToCurrencies = new HashMap();
    private final String currencyCode;

    private Currency(String currencyCode) {
        this.currencyCode = currencyCode;
        String symbol = ICU.getCurrencySymbol(Locale.US.toString(), currencyCode);
        if (symbol == null) {
            throw new IllegalArgumentException("Unsupported ISO 4217 currency code: " + currencyCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Currency getInstance(String currencyCode) {
        HashMap<String, Currency> hashMap = codesToCurrencies;
        synchronized (hashMap) {
            Currency currency = codesToCurrencies.get(currencyCode);
            if (currency == null) {
                currency = new Currency(currencyCode);
                codesToCurrencies.put(currencyCode, currency);
            }
            return currency;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Currency getInstance(Locale locale) {
        HashMap<Locale, Currency> hashMap = localesToCurrencies;
        synchronized (hashMap) {
            String currencyCode;
            Currency currency = localesToCurrencies.get(locale);
            if (currency != null) {
                return currency;
            }
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (!variant.isEmpty() && (variant.equals("EURO") || variant.equals("HK") || variant.equals("PREEURO"))) {
                country = country + "_" + variant;
            }
            if ((currencyCode = ICU.getCurrencyCode(country)) == null) {
                throw new IllegalArgumentException("Unsupported ISO 3166 country: " + locale);
            }
            if (currencyCode.equals("None")) {
                return null;
            }
            Currency result = Currency.getInstance(currencyCode);
            localesToCurrencies.put(locale, result);
            return result;
        }
    }

    public static Set<Currency> getAvailableCurrencies() {
        String[] currencyCodes;
        LinkedHashSet<Currency> result = new LinkedHashSet<Currency>();
        for (String currencyCode : currencyCodes = ICU.getAvailableCurrencyCodes()) {
            result.add(Currency.getInstance(currencyCode));
        }
        return result;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return ICU.getCurrencyDisplayName(locale.toString(), this.currencyCode);
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String getSymbol(Locale locale) {
        if (locale.getCountry().length() == 0) {
            return this.currencyCode;
        }
        LocaleData localeData = LocaleData.get(locale);
        if (localeData.internationalCurrencySymbol.equals(this.currencyCode)) {
            return localeData.currencySymbol;
        }
        String symbol = ICU.getCurrencySymbol(locale.toString(), this.currencyCode);
        return symbol != null ? symbol : this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        if (this.currencyCode.equals("XXX")) {
            return -1;
        }
        return ICU.getCurrencyFractionDigits(this.currencyCode);
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }
}

