/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;

final class DualPivotQuicksort {
    private static final int INSERTION_SORT_THRESHOLD = 32;
    private static final int COUNTING_SORT_THRESHOLD_FOR_BYTE = 128;
    private static final int COUNTING_SORT_THRESHOLD_FOR_SHORT_OR_CHAR = 32768;
    private static final int NUM_SHORT_VALUES = 65536;
    private static final int NUM_CHAR_VALUES = 65536;
    private static final int NUM_BYTE_VALUES = 256;

    private DualPivotQuicksort() {
    }

    public static void sort(int[] a) {
        DualPivotQuicksort.doSort(a, 0, a.length - 1);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        Arrays.checkStartAndEnd(a.length, fromIndex, toIndex);
        DualPivotQuicksort.doSort(a, fromIndex, toIndex - 1);
    }

    private static void doSort(int[] a, int left, int right) {
        if (right - left + 1 < 32) {
            for (int i = left + 1; i <= right; ++i) {
                int ai = a[i];
                for (int j = i - 1; j >= left && ai < a[j]; --j) {
                    a[j + 1] = a[j];
                }
                a[j + 1] = ai;
            }
        } else {
            DualPivotQuicksort.dualPivotQuicksort(a, left, right);
        }
    }

    private static void dualPivotQuicksort(int[] a, int left, int right) {
        int ak;
        int k;
        boolean pivotsDiffer;
        int great;
        int less;
        int pivot2;
        int pivot1;
        int e5;
        int e1;
        block30: {
            int t;
            int sixth = (right - left + 1) / 6;
            e1 = left + sixth;
            e5 = right - sixth;
            int e3 = left + right >>> 1;
            int e4 = e3 + sixth;
            int e2 = e3 - sixth;
            int ae1 = a[e1];
            int ae2 = a[e2];
            int ae3 = a[e3];
            int ae4 = a[e4];
            int ae5 = a[e5];
            if (ae1 > ae2) {
                t = ae1;
                ae1 = ae2;
                ae2 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            if (ae1 > ae3) {
                t = ae1;
                ae1 = ae3;
                ae3 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae1 > ae4) {
                t = ae1;
                ae1 = ae4;
                ae4 = t;
            }
            if (ae3 > ae4) {
                t = ae3;
                ae3 = ae4;
                ae4 = t;
            }
            if (ae2 > ae5) {
                t = ae2;
                ae2 = ae5;
                ae5 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            a[e1] = ae1;
            a[e3] = ae3;
            a[e5] = ae5;
            pivot1 = ae2;
            a[e2] = a[left];
            pivot2 = ae4;
            a[e4] = a[right];
            less = left + 1;
            great = right - 1;
            boolean bl = pivotsDiffer = pivot1 != pivot2;
            if (pivotsDiffer) {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- != k) continue;
                        break block30;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = a[great];
                    a[great--] = ak;
                }
            } else {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak == pivot1) continue;
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    while (a[great] > pivot1) {
                        --great;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = pivot1;
                    a[great--] = ak;
                }
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        DualPivotQuicksort.doSort(a, left, less - 2);
        DualPivotQuicksort.doSort(a, great + 2, right);
        if (!pivotsDiffer) {
            return;
        }
        if (less < e1 && great > e5) {
            while (a[less] == pivot1) {
                ++less;
            }
            while (a[great] == pivot2) {
                --great;
            }
            block6: for (k = less; k <= great; ++k) {
                ak = a[k];
                if (ak == pivot2) {
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block6;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less++] = pivot1;
                    } else {
                        a[k] = a[great];
                    }
                    a[great--] = pivot2;
                    continue;
                }
                if (ak != pivot1) continue;
                a[k] = a[less];
                a[less++] = pivot1;
            }
        }
        DualPivotQuicksort.doSort(a, less, great);
    }

    public static void sort(long[] a) {
        DualPivotQuicksort.doSort(a, 0, a.length - 1);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        Arrays.checkStartAndEnd(a.length, fromIndex, toIndex);
        DualPivotQuicksort.doSort(a, fromIndex, toIndex - 1);
    }

    private static void doSort(long[] a, int left, int right) {
        if (right - left + 1 < 32) {
            for (int i = left + 1; i <= right; ++i) {
                long ai = a[i];
                for (int j = i - 1; j >= left && ai < a[j]; --j) {
                    a[j + 1] = a[j];
                }
                a[j + 1] = ai;
            }
        } else {
            DualPivotQuicksort.dualPivotQuicksort(a, left, right);
        }
    }

    private static void dualPivotQuicksort(long[] a, int left, int right) {
        long ak;
        int k;
        boolean pivotsDiffer;
        int great;
        int less;
        long pivot2;
        long pivot1;
        int e5;
        int e1;
        block30: {
            long t;
            int sixth = (right - left + 1) / 6;
            e1 = left + sixth;
            e5 = right - sixth;
            int e3 = left + right >>> 1;
            int e4 = e3 + sixth;
            int e2 = e3 - sixth;
            long ae1 = a[e1];
            long ae2 = a[e2];
            long ae3 = a[e3];
            long ae4 = a[e4];
            long ae5 = a[e5];
            if (ae1 > ae2) {
                t = ae1;
                ae1 = ae2;
                ae2 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            if (ae1 > ae3) {
                t = ae1;
                ae1 = ae3;
                ae3 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae1 > ae4) {
                t = ae1;
                ae1 = ae4;
                ae4 = t;
            }
            if (ae3 > ae4) {
                t = ae3;
                ae3 = ae4;
                ae4 = t;
            }
            if (ae2 > ae5) {
                t = ae2;
                ae2 = ae5;
                ae5 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            a[e1] = ae1;
            a[e3] = ae3;
            a[e5] = ae5;
            pivot1 = ae2;
            a[e2] = a[left];
            pivot2 = ae4;
            a[e4] = a[right];
            less = left + 1;
            great = right - 1;
            boolean bl = pivotsDiffer = pivot1 != pivot2;
            if (pivotsDiffer) {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- != k) continue;
                        break block30;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = a[great];
                    a[great--] = ak;
                }
            } else {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak == pivot1) continue;
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    while (a[great] > pivot1) {
                        --great;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = pivot1;
                    a[great--] = ak;
                }
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        DualPivotQuicksort.doSort(a, left, less - 2);
        DualPivotQuicksort.doSort(a, great + 2, right);
        if (!pivotsDiffer) {
            return;
        }
        if (less < e1 && great > e5) {
            while (a[less] == pivot1) {
                ++less;
            }
            while (a[great] == pivot2) {
                --great;
            }
            block6: for (k = less; k <= great; ++k) {
                ak = a[k];
                if (ak == pivot2) {
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block6;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less++] = pivot1;
                    } else {
                        a[k] = a[great];
                    }
                    a[great--] = pivot2;
                    continue;
                }
                if (ak != pivot1) continue;
                a[k] = a[less];
                a[less++] = pivot1;
            }
        }
        DualPivotQuicksort.doSort(a, less, great);
    }

    public static void sort(short[] a) {
        DualPivotQuicksort.doSort(a, 0, a.length - 1);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        Arrays.checkStartAndEnd(a.length, fromIndex, toIndex);
        DualPivotQuicksort.doSort(a, fromIndex, toIndex - 1);
    }

    private static void doSort(short[] a, int left, int right) {
        if (right - left + 1 < 32) {
            for (int i = left + 1; i <= right; ++i) {
                short ai = a[i];
                for (int j = i - 1; j >= left && ai < a[j]; --j) {
                    a[j + 1] = a[j];
                }
                a[j + 1] = ai;
            }
        } else if (right - left + 1 > 32768) {
            int i;
            int[] count = new int[65536];
            for (i = left; i <= right; ++i) {
                int n = a[i] - Short.MIN_VALUE;
                count[n] = count[n] + 1;
            }
            int k = left;
            for (i = 0; i < count.length && k <= right; ++i) {
                short value = (short)(i + Short.MIN_VALUE);
                for (int s = count[i]; s > 0; --s) {
                    a[k++] = value;
                }
            }
        } else {
            DualPivotQuicksort.dualPivotQuicksort(a, left, right);
        }
    }

    private static void dualPivotQuicksort(short[] a, int left, int right) {
        short ak;
        int k;
        boolean pivotsDiffer;
        int great;
        int less;
        short pivot2;
        short pivot1;
        int e5;
        int e1;
        block30: {
            short t;
            int sixth = (right - left + 1) / 6;
            e1 = left + sixth;
            e5 = right - sixth;
            int e3 = left + right >>> 1;
            int e4 = e3 + sixth;
            int e2 = e3 - sixth;
            short ae1 = a[e1];
            short ae2 = a[e2];
            short ae3 = a[e3];
            short ae4 = a[e4];
            short ae5 = a[e5];
            if (ae1 > ae2) {
                t = ae1;
                ae1 = ae2;
                ae2 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            if (ae1 > ae3) {
                t = ae1;
                ae1 = ae3;
                ae3 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae1 > ae4) {
                t = ae1;
                ae1 = ae4;
                ae4 = t;
            }
            if (ae3 > ae4) {
                t = ae3;
                ae3 = ae4;
                ae4 = t;
            }
            if (ae2 > ae5) {
                t = ae2;
                ae2 = ae5;
                ae5 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            a[e1] = ae1;
            a[e3] = ae3;
            a[e5] = ae5;
            pivot1 = ae2;
            a[e2] = a[left];
            pivot2 = ae4;
            a[e4] = a[right];
            less = left + 1;
            great = right - 1;
            boolean bl = pivotsDiffer = pivot1 != pivot2;
            if (pivotsDiffer) {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- != k) continue;
                        break block30;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = a[great];
                    a[great--] = ak;
                }
            } else {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak == pivot1) continue;
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    while (a[great] > pivot1) {
                        --great;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = pivot1;
                    a[great--] = ak;
                }
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        DualPivotQuicksort.doSort(a, left, less - 2);
        DualPivotQuicksort.doSort(a, great + 2, right);
        if (!pivotsDiffer) {
            return;
        }
        if (less < e1 && great > e5) {
            while (a[less] == pivot1) {
                ++less;
            }
            while (a[great] == pivot2) {
                --great;
            }
            block6: for (k = less; k <= great; ++k) {
                ak = a[k];
                if (ak == pivot2) {
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block6;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less++] = pivot1;
                    } else {
                        a[k] = a[great];
                    }
                    a[great--] = pivot2;
                    continue;
                }
                if (ak != pivot1) continue;
                a[k] = a[less];
                a[less++] = pivot1;
            }
        }
        DualPivotQuicksort.doSort(a, less, great);
    }

    public static void sort(char[] a) {
        DualPivotQuicksort.doSort(a, 0, a.length - 1);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        Arrays.checkStartAndEnd(a.length, fromIndex, toIndex);
        DualPivotQuicksort.doSort(a, fromIndex, toIndex - 1);
    }

    private static void doSort(char[] a, int left, int right) {
        if (right - left + 1 < 32) {
            for (int i = left + 1; i <= right; ++i) {
                char ai = a[i];
                for (int j = i - 1; j >= left && ai < a[j]; --j) {
                    a[j + 1] = a[j];
                }
                a[j + 1] = ai;
            }
        } else if (right - left + 1 > 32768) {
            int i;
            int[] count = new int[65536];
            for (i = left; i <= right; ++i) {
                char c = a[i];
                count[c] = count[c] + 1;
            }
            int k = left;
            for (i = 0; i < count.length && k <= right; ++i) {
                for (int s = count[i]; s > 0; --s) {
                    a[k++] = (char)i;
                }
            }
        } else {
            DualPivotQuicksort.dualPivotQuicksort(a, left, right);
        }
    }

    private static void dualPivotQuicksort(char[] a, int left, int right) {
        char ak;
        int k;
        boolean pivotsDiffer;
        int great;
        int less;
        char pivot2;
        char pivot1;
        int e5;
        int e1;
        block30: {
            char t;
            int sixth = (right - left + 1) / 6;
            e1 = left + sixth;
            e5 = right - sixth;
            int e3 = left + right >>> 1;
            int e4 = e3 + sixth;
            int e2 = e3 - sixth;
            char ae1 = a[e1];
            char ae2 = a[e2];
            char ae3 = a[e3];
            char ae4 = a[e4];
            char ae5 = a[e5];
            if (ae1 > ae2) {
                t = ae1;
                ae1 = ae2;
                ae2 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            if (ae1 > ae3) {
                t = ae1;
                ae1 = ae3;
                ae3 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae1 > ae4) {
                t = ae1;
                ae1 = ae4;
                ae4 = t;
            }
            if (ae3 > ae4) {
                t = ae3;
                ae3 = ae4;
                ae4 = t;
            }
            if (ae2 > ae5) {
                t = ae2;
                ae2 = ae5;
                ae5 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            a[e1] = ae1;
            a[e3] = ae3;
            a[e5] = ae5;
            pivot1 = ae2;
            a[e2] = a[left];
            pivot2 = ae4;
            a[e4] = a[right];
            less = left + 1;
            great = right - 1;
            boolean bl = pivotsDiffer = pivot1 != pivot2;
            if (pivotsDiffer) {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- != k) continue;
                        break block30;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = a[great];
                    a[great--] = ak;
                }
            } else {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak == pivot1) continue;
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    while (a[great] > pivot1) {
                        --great;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = pivot1;
                    a[great--] = ak;
                }
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        DualPivotQuicksort.doSort(a, left, less - 2);
        DualPivotQuicksort.doSort(a, great + 2, right);
        if (!pivotsDiffer) {
            return;
        }
        if (less < e1 && great > e5) {
            while (a[less] == pivot1) {
                ++less;
            }
            while (a[great] == pivot2) {
                --great;
            }
            block6: for (k = less; k <= great; ++k) {
                ak = a[k];
                if (ak == pivot2) {
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block6;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less++] = pivot1;
                    } else {
                        a[k] = a[great];
                    }
                    a[great--] = pivot2;
                    continue;
                }
                if (ak != pivot1) continue;
                a[k] = a[less];
                a[less++] = pivot1;
            }
        }
        DualPivotQuicksort.doSort(a, less, great);
    }

    public static void sort(byte[] a) {
        DualPivotQuicksort.doSort(a, 0, a.length - 1);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        Arrays.checkStartAndEnd(a.length, fromIndex, toIndex);
        DualPivotQuicksort.doSort(a, fromIndex, toIndex - 1);
    }

    private static void doSort(byte[] a, int left, int right) {
        if (right - left + 1 < 32) {
            for (int i = left + 1; i <= right; ++i) {
                byte ai = a[i];
                for (int j = i - 1; j >= left && ai < a[j]; --j) {
                    a[j + 1] = a[j];
                }
                a[j + 1] = ai;
            }
        } else if (right - left + 1 > 128) {
            int i;
            int[] count = new int[256];
            for (i = left; i <= right; ++i) {
                int n = a[i] - -128;
                count[n] = count[n] + 1;
            }
            int k = left;
            for (i = 0; i < count.length && k <= right; ++i) {
                byte value = (byte)(i + -128);
                for (int s = count[i]; s > 0; --s) {
                    a[k++] = value;
                }
            }
        } else {
            DualPivotQuicksort.dualPivotQuicksort(a, left, right);
        }
    }

    private static void dualPivotQuicksort(byte[] a, int left, int right) {
        byte ak;
        int k;
        boolean pivotsDiffer;
        int great;
        int less;
        byte pivot2;
        byte pivot1;
        int e5;
        int e1;
        block30: {
            byte t;
            int sixth = (right - left + 1) / 6;
            e1 = left + sixth;
            e5 = right - sixth;
            int e3 = left + right >>> 1;
            int e4 = e3 + sixth;
            int e2 = e3 - sixth;
            byte ae1 = a[e1];
            byte ae2 = a[e2];
            byte ae3 = a[e3];
            byte ae4 = a[e4];
            byte ae5 = a[e5];
            if (ae1 > ae2) {
                t = ae1;
                ae1 = ae2;
                ae2 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            if (ae1 > ae3) {
                t = ae1;
                ae1 = ae3;
                ae3 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae1 > ae4) {
                t = ae1;
                ae1 = ae4;
                ae4 = t;
            }
            if (ae3 > ae4) {
                t = ae3;
                ae3 = ae4;
                ae4 = t;
            }
            if (ae2 > ae5) {
                t = ae2;
                ae2 = ae5;
                ae5 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            a[e1] = ae1;
            a[e3] = ae3;
            a[e5] = ae5;
            pivot1 = ae2;
            a[e2] = a[left];
            pivot2 = ae4;
            a[e4] = a[right];
            less = left + 1;
            great = right - 1;
            boolean bl = pivotsDiffer = pivot1 != pivot2;
            if (pivotsDiffer) {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    if (ak <= pivot2) continue;
                    while (a[great] > pivot2) {
                        if (great-- != k) continue;
                        break block30;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = a[great];
                    a[great--] = ak;
                }
            } else {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak == pivot1) continue;
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    while (a[great] > pivot1) {
                        --great;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = pivot1;
                    a[great--] = ak;
                }
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        DualPivotQuicksort.doSort(a, left, less - 2);
        DualPivotQuicksort.doSort(a, great + 2, right);
        if (!pivotsDiffer) {
            return;
        }
        if (less < e1 && great > e5) {
            while (a[less] == pivot1) {
                ++less;
            }
            while (a[great] == pivot2) {
                --great;
            }
            block6: for (k = less; k <= great; ++k) {
                ak = a[k];
                if (ak == pivot2) {
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block6;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less++] = pivot1;
                    } else {
                        a[k] = a[great];
                    }
                    a[great--] = pivot2;
                    continue;
                }
                if (ak != pivot1) continue;
                a[k] = a[less];
                a[less++] = pivot1;
            }
        }
        DualPivotQuicksort.doSort(a, less, great);
    }

    public static void sort(float[] a) {
        DualPivotQuicksort.sortNegZeroAndNaN(a, 0, a.length - 1);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        Arrays.checkStartAndEnd(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sortNegZeroAndNaN(a, fromIndex, toIndex - 1);
    }

    private static void sortNegZeroAndNaN(float[] a, int left, int right) {
        int NEGATIVE_ZERO = Float.floatToIntBits(-0.0f);
        int numNegativeZeros = 0;
        int n = right;
        for (int k = left; k <= n; ++k) {
            float ak = a[k];
            if (ak == 0.0f && NEGATIVE_ZERO == Float.floatToIntBits(ak)) {
                a[k] = 0.0f;
                ++numNegativeZeros;
                continue;
            }
            if (ak == ak) continue;
            a[k--] = a[n];
            a[n--] = Float.NaN;
        }
        DualPivotQuicksort.doSort(a, left, n);
        if (numNegativeZeros == 0) {
            return;
        }
        int zeroIndex = DualPivotQuicksort.findAnyZero(a, left, n);
        int i = zeroIndex - 1;
        while (i >= left && a[i] == 0.0f) {
            zeroIndex = i--;
        }
        int m = zeroIndex + numNegativeZeros;
        for (i = zeroIndex; i < m; ++i) {
            a[i] = -0.0f;
        }
    }

    private static int findAnyZero(float[] a, int low, int high) {
        int middle;
        while (true) {
            float middleValue;
            if ((middleValue = a[middle = low + high >>> 1]) < 0.0f) {
                low = middle + 1;
                continue;
            }
            if (!(middleValue > 0.0f)) break;
            high = middle - 1;
        }
        return middle;
    }

    private static void doSort(float[] a, int left, int right) {
        if (right - left + 1 < 32) {
            for (int i = left + 1; i <= right; ++i) {
                float ai = a[i];
                for (int j = i - 1; j >= left && ai < a[j]; --j) {
                    a[j + 1] = a[j];
                }
                a[j + 1] = ai;
            }
        } else {
            DualPivotQuicksort.dualPivotQuicksort(a, left, right);
        }
    }

    private static void dualPivotQuicksort(float[] a, int left, int right) {
        float ak;
        int k;
        boolean pivotsDiffer;
        int great;
        int less;
        float pivot2;
        float pivot1;
        int e5;
        int e1;
        block30: {
            float t;
            int sixth = (right - left + 1) / 6;
            e1 = left + sixth;
            e5 = right - sixth;
            int e3 = left + right >>> 1;
            int e4 = e3 + sixth;
            int e2 = e3 - sixth;
            float ae1 = a[e1];
            float ae2 = a[e2];
            float ae3 = a[e3];
            float ae4 = a[e4];
            float ae5 = a[e5];
            if (ae1 > ae2) {
                t = ae1;
                ae1 = ae2;
                ae2 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            if (ae1 > ae3) {
                t = ae1;
                ae1 = ae3;
                ae3 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae1 > ae4) {
                t = ae1;
                ae1 = ae4;
                ae4 = t;
            }
            if (ae3 > ae4) {
                t = ae3;
                ae3 = ae4;
                ae4 = t;
            }
            if (ae2 > ae5) {
                t = ae2;
                ae2 = ae5;
                ae5 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            a[e1] = ae1;
            a[e3] = ae3;
            a[e5] = ae5;
            pivot1 = ae2;
            a[e2] = a[left];
            pivot2 = ae4;
            a[e4] = a[right];
            less = left + 1;
            great = right - 1;
            boolean bl = pivotsDiffer = pivot1 != pivot2;
            if (pivotsDiffer) {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    if (!(ak > pivot2)) continue;
                    while (a[great] > pivot2) {
                        if (great-- != k) continue;
                        break block30;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = a[great];
                    a[great--] = ak;
                }
            } else {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak == pivot1) continue;
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    while (a[great] > pivot1) {
                        --great;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = pivot1;
                    a[great--] = ak;
                }
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        DualPivotQuicksort.doSort(a, left, less - 2);
        DualPivotQuicksort.doSort(a, great + 2, right);
        if (!pivotsDiffer) {
            return;
        }
        if (less < e1 && great > e5) {
            while (a[less] == pivot1) {
                ++less;
            }
            while (a[great] == pivot2) {
                --great;
            }
            block6: for (k = less; k <= great; ++k) {
                ak = a[k];
                if (ak == pivot2) {
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block6;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less++] = pivot1;
                    } else {
                        a[k] = a[great];
                    }
                    a[great--] = pivot2;
                    continue;
                }
                if (ak != pivot1) continue;
                a[k] = a[less];
                a[less++] = pivot1;
            }
        }
        DualPivotQuicksort.doSort(a, less, great);
    }

    public static void sort(double[] a) {
        DualPivotQuicksort.sortNegZeroAndNaN(a, 0, a.length - 1);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        Arrays.checkStartAndEnd(a.length, fromIndex, toIndex);
        DualPivotQuicksort.sortNegZeroAndNaN(a, fromIndex, toIndex - 1);
    }

    private static void sortNegZeroAndNaN(double[] a, int left, int right) {
        long NEGATIVE_ZERO = Double.doubleToLongBits(-0.0);
        int numNegativeZeros = 0;
        int n = right;
        for (int k = left; k <= n; ++k) {
            double ak = a[k];
            if (ak == 0.0 && NEGATIVE_ZERO == Double.doubleToLongBits(ak)) {
                a[k] = 0.0;
                ++numNegativeZeros;
                continue;
            }
            if (ak == ak) continue;
            a[k--] = a[n];
            a[n--] = Double.NaN;
        }
        DualPivotQuicksort.doSort(a, left, n);
        if (numNegativeZeros == 0) {
            return;
        }
        int zeroIndex = DualPivotQuicksort.findAnyZero(a, left, n);
        int i = zeroIndex - 1;
        while (i >= left && a[i] == 0.0) {
            zeroIndex = i--;
        }
        int m = zeroIndex + numNegativeZeros;
        for (i = zeroIndex; i < m; ++i) {
            a[i] = -0.0;
        }
    }

    private static int findAnyZero(double[] a, int low, int high) {
        int middle;
        while (true) {
            double middleValue;
            if ((middleValue = a[middle = low + high >>> 1]) < 0.0) {
                low = middle + 1;
                continue;
            }
            if (!(middleValue > 0.0)) break;
            high = middle - 1;
        }
        return middle;
    }

    private static void doSort(double[] a, int left, int right) {
        if (right - left + 1 < 32) {
            for (int i = left + 1; i <= right; ++i) {
                double ai = a[i];
                for (int j = i - 1; j >= left && ai < a[j]; --j) {
                    a[j + 1] = a[j];
                }
                a[j + 1] = ai;
            }
        } else {
            DualPivotQuicksort.dualPivotQuicksort(a, left, right);
        }
    }

    private static void dualPivotQuicksort(double[] a, int left, int right) {
        double ak;
        int k;
        boolean pivotsDiffer;
        int great;
        int less;
        double pivot2;
        double pivot1;
        int e5;
        int e1;
        block30: {
            double t;
            int sixth = (right - left + 1) / 6;
            e1 = left + sixth;
            e5 = right - sixth;
            int e3 = left + right >>> 1;
            int e4 = e3 + sixth;
            int e2 = e3 - sixth;
            double ae1 = a[e1];
            double ae2 = a[e2];
            double ae3 = a[e3];
            double ae4 = a[e4];
            double ae5 = a[e5];
            if (ae1 > ae2) {
                t = ae1;
                ae1 = ae2;
                ae2 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            if (ae1 > ae3) {
                t = ae1;
                ae1 = ae3;
                ae3 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae1 > ae4) {
                t = ae1;
                ae1 = ae4;
                ae4 = t;
            }
            if (ae3 > ae4) {
                t = ae3;
                ae3 = ae4;
                ae4 = t;
            }
            if (ae2 > ae5) {
                t = ae2;
                ae2 = ae5;
                ae5 = t;
            }
            if (ae2 > ae3) {
                t = ae2;
                ae2 = ae3;
                ae3 = t;
            }
            if (ae4 > ae5) {
                t = ae4;
                ae4 = ae5;
                ae5 = t;
            }
            a[e1] = ae1;
            a[e3] = ae3;
            a[e5] = ae5;
            pivot1 = ae2;
            a[e2] = a[left];
            pivot2 = ae4;
            a[e4] = a[right];
            less = left + 1;
            great = right - 1;
            boolean bl = pivotsDiffer = pivot1 != pivot2;
            if (pivotsDiffer) {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    if (!(ak > pivot2)) continue;
                    while (a[great] > pivot2) {
                        if (great-- != k) continue;
                        break block30;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = a[great];
                    a[great--] = ak;
                }
            } else {
                for (k = less; k <= great; ++k) {
                    ak = a[k];
                    if (ak == pivot1) continue;
                    if (ak < pivot1) {
                        if (k != less) {
                            a[k] = a[less];
                            a[less] = ak;
                        }
                        ++less;
                        continue;
                    }
                    while (a[great] > pivot1) {
                        --great;
                    }
                    if (a[great] < pivot1) {
                        a[k] = a[less];
                        a[less++] = a[great];
                        a[great--] = ak;
                        continue;
                    }
                    a[k] = pivot1;
                    a[great--] = ak;
                }
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        DualPivotQuicksort.doSort(a, left, less - 2);
        DualPivotQuicksort.doSort(a, great + 2, right);
        if (!pivotsDiffer) {
            return;
        }
        if (less < e1 && great > e5) {
            while (a[less] == pivot1) {
                ++less;
            }
            while (a[great] == pivot2) {
                --great;
            }
            block6: for (k = less; k <= great; ++k) {
                ak = a[k];
                if (ak == pivot2) {
                    while (a[great] == pivot2) {
                        if (great-- != k) continue;
                        break block6;
                    }
                    if (a[great] == pivot1) {
                        a[k] = a[less];
                        a[less++] = pivot1;
                    } else {
                        a[k] = a[great];
                    }
                    a[great--] = pivot2;
                    continue;
                }
                if (ak != pivot1) continue;
                a[k] = a[less];
                a[less++] = pivot1;
            }
        }
        DualPivotQuicksort.doSort(a, less, great);
    }
}

