/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HugeEnumSet;
import java.util.Iterator;
import java.util.MiniEnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1009687484059888093L;
    final Class<E> elementClass;

    EnumSet(Class<E> cls) {
        this.elementClass = cls;
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> elementType) {
        if (!elementType.isEnum()) {
            throw new ClassCastException(elementType.getClass().getName() + " is not an Enum");
        }
        Enum[] enums = Enum.getSharedConstants(elementType);
        if (enums.length <= 64) {
            return new MiniEnumSet(elementType, enums);
        }
        return new HugeEnumSet(elementType, enums);
    }

    public static <E extends Enum<E>> EnumSet<E> allOf(Class<E> elementType) {
        EnumSet<E> set = EnumSet.noneOf(elementType);
        set.complement();
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(EnumSet<E> s) {
        EnumSet<E> set = EnumSet.noneOf(s.elementClass);
        set.addAll(s);
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> c) {
        if (c instanceof EnumSet) {
            return EnumSet.copyOf((EnumSet)c);
        }
        if (c.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Iterator<E> iterator = c.iterator();
        Enum element = (Enum)iterator.next();
        EnumSet<Enum> set = EnumSet.noneOf(element.getDeclaringClass());
        set.add(element);
        while (iterator.hasNext()) {
            set.add((Enum)iterator.next());
        }
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(EnumSet<E> s) {
        EnumSet<E> set = EnumSet.noneOf(s.elementClass);
        set.addAll(s);
        set.complement();
        return set;
    }

    abstract void complement();

    public static <E extends Enum<E>> EnumSet<E> of(E e) {
        EnumSet<E> set = EnumSet.noneOf(e.getDeclaringClass());
        set.add(e);
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2) {
        EnumSet<E> set = EnumSet.of(e1);
        set.add(e2);
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3) {
        EnumSet<E> set = EnumSet.of(e1, e2);
        set.add(e3);
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3, E e4) {
        EnumSet<E> set = EnumSet.of(e1, e2, e3);
        set.add(e4);
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        EnumSet<E> set = EnumSet.of(e1, e2, e3, e4);
        set.add(e5);
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E start, E ... others) {
        EnumSet<E> set = EnumSet.of(start);
        for (E e : others) {
            set.add(e);
        }
        return set;
    }

    public static <E extends Enum<E>> EnumSet<E> range(E start, E end) {
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException();
        }
        EnumSet<E> set = EnumSet.noneOf(start.getDeclaringClass());
        set.setRange(start, end);
        return set;
    }

    abstract void setRange(E var1, E var2);

    public EnumSet<E> clone() {
        try {
            return (EnumSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    boolean isValidType(Class<?> cls) {
        return cls == this.elementClass || cls.getSuperclass() == this.elementClass;
    }

    Object writeReplace() {
        SerializationProxy proxy = new SerializationProxy();
        SerializationProxy.access$102(proxy, this.toArray(new Enum[0]));
        proxy.elementType = this.elementClass;
        return proxy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<E extends Enum<E>>
    implements Serializable {
        private static final long serialVersionUID = 362491234563181265L;
        private Class<E> elementType;
        private E[] elements;

        private SerializationProxy() {
        }

        private Object readResolve() {
            EnumSet<E> set = EnumSet.noneOf(this.elementType);
            for (E e : this.elements) {
                set.add(e);
            }
            return set;
        }

        static /* synthetic */ Enum[] access$102(SerializationProxy x0, Enum[] x1) {
            x0.elements = x1;
            return x1;
        }
    }
}

