/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HugeEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private static final int BIT_IN_LONG = 64;
    private final E[] enums;
    private long[] bits;
    private int size;

    HugeEnumSet(Class<E> elementType, E[] enums) {
        super(elementType);
        this.enums = enums;
        this.bits = new long[(enums.length + 64 - 1) / 64];
    }

    @Override
    public boolean add(E element) {
        this.elementClass.cast(element);
        int ordinal = ((Enum)element).ordinal();
        int index = ordinal / 64;
        int inBits = ordinal % 64;
        long oldBits = this.bits[index];
        long newBits = oldBits | 1L << inBits;
        if (oldBits != newBits) {
            this.bits[index] = newBits;
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty() || collection == this) {
            return false;
        }
        if (collection instanceof EnumSet) {
            EnumSet set = (EnumSet)collection;
            set.elementClass.asSubclass(this.elementClass);
            HugeEnumSet hugeSet = (HugeEnumSet)set;
            boolean changed = false;
            for (int i = 0; i < this.bits.length; ++i) {
                long oldBits = this.bits[i];
                long newBits = oldBits | hugeSet.bits[i];
                if (oldBits == newBits) continue;
                this.bits[i] = newBits;
                this.size += Long.bitCount(newBits) - Long.bitCount(oldBits);
                changed = true;
            }
            return changed;
        }
        return super.addAll(collection);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.bits, 0L);
        this.size = 0;
    }

    @Override
    protected void complement() {
        this.size = 0;
        int length = this.bits.length;
        for (int i = 0; i < length; ++i) {
            long b = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
            if (i == length - 1) {
                b &= -1L >>> 64 - this.enums.length % 64;
            }
            this.size += Long.bitCount(b);
            this.bits[i] = b;
        }
    }

    @Override
    public boolean contains(Object object) {
        int inBits;
        if (object == null || !this.isValidType(object.getClass())) {
            return false;
        }
        int ordinal = ((Enum)object).ordinal();
        int index = ordinal / 64;
        return (this.bits[index] & 1L << (inBits = ordinal % 64)) != 0L;
    }

    @Override
    public HugeEnumSet<E> clone() {
        HugeEnumSet set = (HugeEnumSet)super.clone();
        set.bits = (long[])this.bits.clone();
        return set;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        if (collection instanceof HugeEnumSet) {
            HugeEnumSet set = (HugeEnumSet)collection;
            if (this.isValidType(set.elementClass)) {
                for (int i = 0; i < this.bits.length; ++i) {
                    long setBits = set.bits[i];
                    if ((this.bits[i] & setBits) == setBits) continue;
                    return false;
                }
                return true;
            }
        }
        return !(collection instanceof EnumSet) && super.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.isValidType(object.getClass())) {
            return super.equals(object);
        }
        return Arrays.equals(this.bits, ((HugeEnumSet)object).bits);
    }

    @Override
    public Iterator<E> iterator() {
        return new HugeEnumSetIterator();
    }

    @Override
    public boolean remove(Object object) {
        int inBits;
        long newBits;
        if (object == null || !this.isValidType(object.getClass())) {
            return false;
        }
        int ordinal = ((Enum)object).ordinal();
        int index = ordinal / 64;
        long oldBits = this.bits[index];
        if (oldBits != (newBits = oldBits & (1L << (inBits = ordinal % 64) ^ 0xFFFFFFFFFFFFFFFFL))) {
            this.bits[index] = newBits;
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (collection instanceof EnumSet) {
            EnumSet set = (EnumSet)collection;
            if (!this.isValidType(set.elementClass)) {
                return false;
            }
            HugeEnumSet hugeSet = (HugeEnumSet)set;
            boolean changed = false;
            for (int i = 0; i < this.bits.length; ++i) {
                long oldBits = this.bits[i];
                long newBits = oldBits & (hugeSet.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
                if (oldBits == newBits) continue;
                this.bits[i] = newBits;
                this.size += Long.bitCount(newBits) - Long.bitCount(oldBits);
                changed = true;
            }
            return changed;
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof EnumSet) {
            EnumSet set = (EnumSet)collection;
            if (!this.isValidType(set.elementClass)) {
                if (this.size > 0) {
                    this.clear();
                    return true;
                }
                return false;
            }
            HugeEnumSet hugeSet = (HugeEnumSet)set;
            boolean changed = false;
            for (int i = 0; i < this.bits.length; ++i) {
                long oldBits = this.bits[i];
                long newBits = oldBits & hugeSet.bits[i];
                if (oldBits == newBits) continue;
                this.bits[i] = newBits;
                this.size += Long.bitCount(newBits) - Long.bitCount(oldBits);
                changed = true;
            }
            return changed;
        }
        return super.retainAll(collection);
    }

    @Override
    void setRange(E start, E end) {
        int startOrdinal = ((Enum)start).ordinal();
        int startIndex = startOrdinal / 64;
        int startInBits = startOrdinal % 64;
        int endOrdinal = ((Enum)end).ordinal();
        int endIndex = endOrdinal / 64;
        int endInBits = endOrdinal % 64;
        if (startIndex == endIndex) {
            long range = -1L >>> 64 - (endInBits - startInBits + 1) << startInBits;
            this.size -= Long.bitCount(this.bits[startIndex]);
            int n = startIndex;
            this.bits[n] = this.bits[n] | range;
            this.size += Long.bitCount(this.bits[startIndex]);
        } else {
            long range = -1L >>> startInBits << startInBits;
            this.size -= Long.bitCount(this.bits[startIndex]);
            int n = startIndex;
            this.bits[n] = this.bits[n] | range;
            this.size += Long.bitCount(this.bits[startIndex]);
            range = -1L >>> 64 - (endInBits + 1);
            this.size -= Long.bitCount(this.bits[endIndex]);
            int n2 = endIndex;
            this.bits[n2] = this.bits[n2] | range;
            this.size += Long.bitCount(this.bits[endIndex]);
            for (int i = startIndex + 1; i <= endIndex - 1; ++i) {
                this.size -= Long.bitCount(this.bits[i]);
                this.bits[i] = -1L;
                this.size += Long.bitCount(this.bits[i]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HugeEnumSetIterator
    implements Iterator<E> {
        private long currentBits;
        private int index;
        private long mask;
        private E last;

        private HugeEnumSetIterator() {
            this.currentBits = HugeEnumSet.this.bits[0];
            this.computeNextElement();
        }

        void computeNextElement() {
            while (true) {
                if (this.currentBits != 0L) {
                    this.mask = this.currentBits & -this.currentBits;
                    return;
                }
                if (++this.index >= HugeEnumSet.this.bits.length) break;
                this.currentBits = HugeEnumSet.this.bits[this.index];
            }
            this.mask = 0L;
        }

        @Override
        public boolean hasNext() {
            return this.mask != 0L;
        }

        @Override
        public E next() {
            if (this.mask == 0L) {
                throw new NoSuchElementException();
            }
            int ordinal = Long.numberOfTrailingZeros(this.mask) + this.index * 64;
            this.last = HugeEnumSet.this.enums[ordinal];
            this.currentBits &= this.mask ^ 0xFFFFFFFFFFFFFFFFL;
            this.computeNextElement();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HugeEnumSet.this.remove(this.last);
            this.last = null;
        }
    }
}

