/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends Hashtable<Object, Object> {
    private static final long serialVersionUID = 4112578634029874840L;
    private transient DocumentBuilder builder = null;
    private static final String PROP_DTD_NAME = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROP_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>    <!ELEMENT properties (comment?, entry*) >    <!ATTLIST properties version CDATA #FIXED \"1.0\" >    <!ELEMENT comment (#PCDATA) >    <!ELEMENT entry (#PCDATA) >    <!ATTLIST entry key CDATA #REQUIRED >";
    protected Properties defaults;
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;

    public Properties() {
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    private void dumpString(StringBuilder buffer, String string, boolean key) {
        int i = 0;
        if (!key && i < string.length() && string.charAt(i) == ' ') {
            buffer.append("\\ ");
            ++i;
        }
        while (i < string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if ("\\#!=:".indexOf(ch) >= 0 || key && ch == ' ') {
                        buffer.append('\\');
                    }
                    if (ch >= ' ' && ch <= '~') {
                        buffer.append(ch);
                        break;
                    }
                    String hex = Integer.toHexString(ch);
                    buffer.append("\\u");
                    for (int j = 0; j < 4 - hex.length(); ++j) {
                        buffer.append("0");
                    }
                    buffer.append(hex);
                }
            }
            ++i;
        }
    }

    public String getProperty(String name) {
        String property;
        Object result = super.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        return property;
    }

    public String getProperty(String name, String defaultValue) {
        String property;
        Object result = super.get(name);
        String string = property = result instanceof String ? (String)result : null;
        if (property == null && this.defaults != null) {
            property = this.defaults.getProperty(name);
        }
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    public void list(PrintStream out) {
        this.listToAppendable(out);
    }

    public void list(PrintWriter out) {
        this.listToAppendable(out);
    }

    private void listToAppendable(Appendable out) {
        try {
            if (out == null) {
                throw new NullPointerException("out == null");
            }
            StringBuilder sb = new StringBuilder(80);
            Enumeration<?> keys = this.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                sb.append(key);
                sb.append('=');
                String property = (String)super.get(key);
                Properties def = this.defaults;
                while (property == null) {
                    property = (String)def.get(key);
                    def = def.defaults;
                }
                if (property.length() > 40) {
                    sb.append(property.substring(0, 37));
                    sb.append("...");
                } else {
                    sb.append(property);
                }
                sb.append(System.lineSeparator());
                out.append(sb.toString());
                sb.setLength(0);
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public synchronized void load(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        this.load(new InputStreamReader(in, "ISO-8859-1"));
    }

    public synchronized void load(Reader in) throws IOException {
        int intVal;
        if (in == null) {
            throw new NullPointerException();
        }
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        BufferedReader br = new BufferedReader(in);
        block17: while ((intVal = br.read()) != -1) {
            int nextChar = intVal;
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (mode == 2) {
                int digit = Character.digit((char)nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) {
                        continue;
                    }
                } else if (count <= 4) {
                    throw new IllegalArgumentException("Invalid Unicode sequence: illegal character");
                }
                mode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != 10) continue;
            }
            if (mode == 1) {
                mode = 0;
                switch (nextChar) {
                    case 13: {
                        mode = 3;
                        continue block17;
                    }
                    case 10: {
                        mode = 5;
                        continue block17;
                    }
                    case 98: {
                        nextChar = 8;
                        break;
                    }
                    case 102: {
                        nextChar = 12;
                        break;
                    }
                    case 110: {
                        nextChar = 10;
                        break;
                    }
                    case 114: {
                        nextChar = 13;
                        break;
                    }
                    case 116: {
                        nextChar = 9;
                        break;
                    }
                    case 117: {
                        mode = 2;
                        count = 0;
                        unicode = 0;
                        continue block17;
                    }
                }
            } else {
                switch (nextChar) {
                    case 33: 
                    case 35: {
                        if (!firstChar) break;
                        while ((intVal = br.read()) != -1 && (nextChar = (int)((char)intVal)) != 13 && nextChar != 10) {
                        }
                        continue block17;
                    }
                    case 10: {
                        if (mode == 3) {
                            mode = 5;
                            continue block17;
                        }
                    }
                    case 13: {
                        mode = 0;
                        firstChar = true;
                        if (offset > 0 || offset == 0 && keyLength == 0) {
                            if (keyLength == -1) {
                                keyLength = offset;
                            }
                            String temp = new String(buf, 0, offset);
                            this.put(temp.substring(0, keyLength), temp.substring(keyLength));
                        }
                        keyLength = -1;
                        offset = 0;
                        continue block17;
                    }
                    case 92: {
                        if (mode == 4) {
                            keyLength = offset;
                        }
                        mode = 1;
                        continue block17;
                    }
                    case 58: 
                    case 61: {
                        if (keyLength != -1) break;
                        mode = 0;
                        keyLength = offset;
                        continue block17;
                    }
                }
                if (Character.isWhitespace((char)nextChar)) {
                    if (mode == 3) {
                        mode = 5;
                    }
                    if (offset == 0 || offset == keyLength || mode == 5) continue;
                    if (keyLength == -1) {
                        mode = 4;
                        continue;
                    }
                }
                if (mode == 5 || mode == 3) {
                    mode = 0;
                }
            }
            firstChar = false;
            if (mode == 4) {
                keyLength = offset;
                mode = 0;
            }
            buf[offset++] = nextChar;
        }
        if (mode == 2 && count <= 4) {
            throw new IllegalArgumentException("Invalid Unicode sequence: expected format \\uxxxx");
        }
        if (keyLength == -1 && offset > 0) {
            keyLength = offset;
        }
        if (keyLength >= 0) {
            String temp = new String(buf, 0, offset);
            String key = temp.substring(0, keyLength);
            String value = temp.substring(keyLength);
            if (mode == 1) {
                value = value + "\u0000";
            }
            this.put(key, value);
        }
    }

    public Enumeration<?> propertyNames() {
        Hashtable selected = new Hashtable();
        this.selectProperties(selected, false);
        return selected.keys();
    }

    public Set<String> stringPropertyNames() {
        Hashtable stringProperties = new Hashtable();
        this.selectProperties(stringProperties, true);
        return Collections.unmodifiableSet(stringProperties.keySet());
    }

    private <K> void selectProperties(Hashtable<K, Object> selectProperties, boolean isStringOnly) {
        if (this.defaults != null) {
            this.defaults.selectProperties(selectProperties, isStringOnly);
        }
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (isStringOnly && !(key instanceof String)) continue;
            Object value = this.get(key);
            selectProperties.put(key, value);
        }
    }

    @Deprecated
    public void save(OutputStream out, String comment) {
        try {
            this.store(out, comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object setProperty(String name, String value) {
        return this.put(name, value);
    }

    public synchronized void store(OutputStream out, String comment) throws IOException {
        this.store(new OutputStreamWriter(out, "ISO-8859-1"), comment);
    }

    public synchronized void store(Writer writer, String comment) throws IOException {
        if (comment != null) {
            writer.write("#");
            writer.write(comment);
            writer.write(System.lineSeparator());
        }
        writer.write("#");
        writer.write(new Date().toString());
        writer.write(System.lineSeparator());
        StringBuilder sb = new StringBuilder(200);
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            this.dumpString(sb, key, true);
            sb.append('=');
            this.dumpString(sb, (String)entry.getValue(), false);
            sb.append(System.lineSeparator());
            writer.write(sb.toString());
            sb.setLength(0);
        }
        writer.flush();
    }

    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        if (in == null) {
            throw new NullPointerException();
        }
        if (this.builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                this.builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error(e);
            }
            this.builder.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            this.builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.equals(Properties.PROP_DTD_NAME)) {
                        InputSource result = new InputSource(new StringReader(Properties.PROP_DTD));
                        result.setSystemId(Properties.PROP_DTD_NAME);
                        return result;
                    }
                    throw new SAXException("Invalid DOCTYPE declaration: " + systemId);
                }
            });
        }
        try {
            Document doc = this.builder.parse(in);
            NodeList entries = doc.getElementsByTagName("entry");
            if (entries == null) {
                return;
            }
            int entriesListLength = entries.getLength();
            for (int i = 0; i < entriesListLength; ++i) {
                Element entry = (Element)entries.item(i);
                String key = entry.getAttribute("key");
                String value = entry.getTextContent();
                this.put(key, value);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new InvalidPropertiesFormatException(e);
        }
    }

    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.storeToXML(os, comment, "UTF-8");
    }

    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        String encodingCanonicalName;
        if (os == null || encoding == null) {
            throw new NullPointerException();
        }
        try {
            encodingCanonicalName = Charset.forName(encoding).name();
        }
        catch (IllegalCharsetNameException e) {
            System.out.println("Warning: encoding name " + encoding + " is illegal, using UTF-8 as default encoding");
            encodingCanonicalName = "UTF-8";
        }
        catch (UnsupportedCharsetException e) {
            System.out.println("Warning: encoding " + encoding + " is not supported, using UTF-8 as default encoding");
            encodingCanonicalName = "UTF-8";
        }
        PrintStream printStream = new PrintStream(os, false, encodingCanonicalName);
        printStream.print("<?xml version=\"1.0\" encoding=\"");
        printStream.print(encodingCanonicalName);
        printStream.println("\"?>");
        printStream.print("<!DOCTYPE properties SYSTEM \"");
        printStream.print(PROP_DTD_NAME);
        printStream.println("\">");
        printStream.println("<properties>");
        if (comment != null) {
            printStream.print("<comment>");
            printStream.print(this.substitutePredefinedEntries(comment));
            printStream.println("</comment>");
        }
        for (Map.Entry entry : this.entrySet()) {
            String keyValue = (String)entry.getKey();
            String entryValue = (String)entry.getValue();
            printStream.print("<entry key=\"");
            printStream.print(this.substitutePredefinedEntries(keyValue));
            printStream.print("\">");
            printStream.print(this.substitutePredefinedEntries(entryValue));
            printStream.println("</entry>");
        }
        printStream.println("</properties>");
        printStream.flush();
    }

    private String substitutePredefinedEntries(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("\"", "&quot;");
        return s;
    }
}

