/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResourceBundle
extends ResourceBundle {
    Properties resources;

    public PropertyResourceBundle(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        this.resources = new Properties();
        this.resources.load(stream);
    }

    public PropertyResourceBundle(Reader reader) throws IOException {
        this.resources = new Properties();
        this.resources.load(reader);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.resources.stringPropertyNames();
    }

    private Enumeration<String> getLocalKeys() {
        return this.resources.propertyNames();
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.parent == null) {
            return this.getLocalKeys();
        }
        return new Enumeration<String>(){
            Enumeration<String> local;
            Enumeration<String> pEnum;
            String nextElement;
            {
                this.local = PropertyResourceBundle.this.getLocalKeys();
                this.pEnum = PropertyResourceBundle.this.parent.getKeys();
            }

            private boolean findNext() {
                if (this.nextElement != null) {
                    return true;
                }
                while (this.pEnum.hasMoreElements()) {
                    String next = this.pEnum.nextElement();
                    if (PropertyResourceBundle.this.resources.containsKey(next)) continue;
                    this.nextElement = next;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.local.hasMoreElements()) {
                    return true;
                }
                return this.findNext();
            }

            @Override
            public String nextElement() {
                if (this.local.hasMoreElements()) {
                    return this.local.nextElement();
                }
                if (this.findNext()) {
                    String result = this.nextElement;
                    this.nextElement = null;
                    return result;
                }
                return this.pEnum.nextElement();
            }
        };
    }

    @Override
    public Object handleGetObject(String key) {
        return this.resources.get(key);
    }
}

