/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scanner
implements Iterator<String> {
    private static final Pattern DEFAULT_DELIMITER = Pattern.compile("\\p{javaWhitespace}+");
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("true|false", 2);
    private static final Pattern LINE_TERMINATOR;
    private static final Pattern MULTI_LINE_TERMINATOR;
    private static final Pattern LINE_PATTERN;
    private static final Pattern ANY_PATTERN;
    private static final int DIPLOID = 2;
    private static final int DEFAULT_RADIX = 10;
    private static final int DEFAULT_TRUNK_SIZE = 1024;
    private Readable input;
    private CharBuffer buffer;
    private Pattern delimiter = DEFAULT_DELIMITER;
    private Matcher matcher;
    private int integerRadix = 10;
    private Locale locale = Locale.getDefault();
    private int findStartIndex;
    private int preStartIndex = this.findStartIndex = 0;
    private int bufferLength = 0;
    private boolean closed = false;
    private IOException lastIOException;
    private boolean matchSuccessful = false;
    private DecimalFormat decimalFormat;
    private boolean inputExhausted = false;
    private Object cacheHasNextValue = null;
    private int cachehasNextIndex = -1;

    public Scanner(File src) throws FileNotFoundException {
        this(src, Charset.defaultCharset().name());
    }

    public Scanner(File src, String charsetName) throws FileNotFoundException {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        FileInputStream fis = new FileInputStream(src);
        if (charsetName == null) {
            throw new IllegalArgumentException("charsetName == null");
        }
        try {
            this.input = new InputStreamReader((InputStream)fis, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            IoUtils.closeQuietly(fis);
            throw new IllegalArgumentException(e.getMessage());
        }
        this.initialization();
    }

    public Scanner(String src) {
        this.input = new StringReader(src);
        this.initialization();
    }

    public Scanner(InputStream src) {
        this(src, Charset.defaultCharset().name());
    }

    public Scanner(InputStream src, String charsetName) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        try {
            this.input = new InputStreamReader(src, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.initialization();
    }

    public Scanner(Readable src) {
        if (src == null) {
            throw new NullPointerException();
        }
        this.input = src;
        this.initialization();
    }

    public Scanner(ReadableByteChannel src) {
        this(src, Charset.defaultCharset().name());
    }

    public Scanner(ReadableByteChannel src, String charsetName) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("charsetName == null");
        }
        this.input = Channels.newReader(src, charsetName);
        this.initialization();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.input instanceof Closeable) {
            try {
                ((Closeable)((Object)this.input)).close();
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        }
        this.closed = true;
    }

    public Pattern delimiter() {
        return this.delimiter;
    }

    public String findInLine(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        int horizonLineSeparator = 0;
        this.matcher.usePattern(MULTI_LINE_TERMINATOR);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        boolean findComplete = false;
        int terminatorLength = 0;
        while (!findComplete) {
            if (this.matcher.find()) {
                horizonLineSeparator = this.matcher.start();
                terminatorLength = this.matcher.end() - this.matcher.start();
                findComplete = true;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            horizonLineSeparator = this.bufferLength;
            findComplete = true;
        }
        this.matcher.usePattern(pattern);
        int oldLimit = this.buffer.limit();
        this.buffer.limit(horizonLineSeparator + terminatorLength);
        this.matcher.region(this.findStartIndex, horizonLineSeparator + terminatorLength);
        if (this.matcher.find()) {
            this.findStartIndex = this.matcher.end();
            if (horizonLineSeparator == this.matcher.end()) {
                this.findStartIndex += terminatorLength;
            }
            if (horizonLineSeparator != this.bufferLength && horizonLineSeparator + terminatorLength == this.matcher.end()) {
                this.buffer.limit(oldLimit);
                this.matchSuccessful = false;
                return null;
            }
            this.matchSuccessful = true;
            this.buffer.limit(oldLimit);
            return this.matcher.group();
        }
        this.buffer.limit(oldLimit);
        this.matchSuccessful = false;
        return null;
    }

    public String findInLine(String pattern) {
        return this.findInLine(Pattern.compile(pattern));
    }

    public String findWithinHorizon(Pattern pattern, int horizon) {
        this.checkClosed();
        this.checkNull(pattern);
        if (horizon < 0) {
            throw new IllegalArgumentException("horizon < 0");
        }
        this.matcher.usePattern(pattern);
        String result = null;
        int findEndIndex = 0;
        int horizonEndIndex = 0;
        horizonEndIndex = horizon == 0 ? Integer.MAX_VALUE : this.findStartIndex + horizon;
        while (true) {
            findEndIndex = this.bufferLength;
            findEndIndex = Math.min(horizonEndIndex, this.bufferLength);
            boolean isHorizonInBuffer = horizonEndIndex <= this.bufferLength;
            this.matcher.region(this.findStartIndex, findEndIndex);
            if (this.matcher.find()) {
                if (isHorizonInBuffer || this.inputExhausted) {
                    result = this.matcher.group();
                    break;
                }
            } else if (isHorizonInBuffer || this.inputExhausted) break;
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        if (result != null) {
            this.findStartIndex = this.matcher.end();
            this.matchSuccessful = true;
        } else {
            this.matchSuccessful = false;
        }
        return result;
    }

    public String findWithinHorizon(String pattern, int horizon) {
        return this.findWithinHorizon(Pattern.compile(pattern), horizon);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(ANY_PATTERN);
    }

    public boolean hasNext(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        this.matchSuccessful = false;
        this.saveCurrentStatus();
        if (!this.setTokenRegion()) {
            this.recoverPreviousStatus();
            return false;
        }
        this.matcher.usePattern(pattern);
        boolean hasNext = false;
        if (this.matcher.matches()) {
            this.cachehasNextIndex = this.findStartIndex;
            this.matchSuccessful = true;
            hasNext = true;
        }
        this.recoverPreviousStatus();
        return hasNext;
    }

    public boolean hasNext(String pattern) {
        return this.hasNext(Pattern.compile(pattern));
    }

    public boolean hasNextBigDecimal() {
        Pattern floatPattern = this.getFloatPattern();
        boolean isBigDecimalValue = false;
        if (this.hasNext(floatPattern)) {
            String floatString = this.matcher.group();
            floatString = this.removeLocaleInfoFromFloat(floatString);
            try {
                this.cacheHasNextValue = new BigDecimal(floatString);
                isBigDecimalValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isBigDecimalValue;
    }

    public boolean hasNextBigInteger() {
        return this.hasNextBigInteger(this.integerRadix);
    }

    public boolean hasNextBigInteger(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isBigIntegerValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, DataType.INT);
            try {
                this.cacheHasNextValue = new BigInteger(intString, radix);
                isBigIntegerValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isBigIntegerValue;
    }

    public boolean hasNextBoolean() {
        return this.hasNext(BOOLEAN_PATTERN);
    }

    public boolean hasNextByte() {
        return this.hasNextByte(this.integerRadix);
    }

    public boolean hasNextByte(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isByteValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, DataType.INT);
            try {
                this.cacheHasNextValue = Byte.valueOf(intString, radix);
                isByteValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isByteValue;
    }

    public boolean hasNextDouble() {
        Pattern floatPattern = this.getFloatPattern();
        boolean isDoubleValue = false;
        if (this.hasNext(floatPattern)) {
            String floatString = this.matcher.group();
            floatString = this.removeLocaleInfoFromFloat(floatString);
            try {
                this.cacheHasNextValue = Double.valueOf(floatString);
                isDoubleValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isDoubleValue;
    }

    public boolean hasNextFloat() {
        Pattern floatPattern = this.getFloatPattern();
        boolean isFloatValue = false;
        if (this.hasNext(floatPattern)) {
            String floatString = this.matcher.group();
            floatString = this.removeLocaleInfoFromFloat(floatString);
            try {
                this.cacheHasNextValue = Float.valueOf(floatString);
                isFloatValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isFloatValue;
    }

    public boolean hasNextInt() {
        return this.hasNextInt(this.integerRadix);
    }

    public boolean hasNextInt(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isIntValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, DataType.INT);
            try {
                this.cacheHasNextValue = Integer.valueOf(intString, radix);
                isIntValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isIntValue;
    }

    public boolean hasNextLine() {
        this.checkClosed();
        this.matcher.usePattern(LINE_PATTERN);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        boolean hasNextLine = false;
        while (true) {
            if (this.matcher.find()) {
                if (this.inputExhausted || this.matcher.end() != this.bufferLength) {
                    this.matchSuccessful = true;
                    hasNextLine = true;
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                break;
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        return hasNextLine;
    }

    public boolean hasNextLong() {
        return this.hasNextLong(this.integerRadix);
    }

    public boolean hasNextLong(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isLongValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, DataType.INT);
            try {
                this.cacheHasNextValue = Long.valueOf(intString, radix);
                isLongValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isLongValue;
    }

    public boolean hasNextShort() {
        return this.hasNextShort(this.integerRadix);
    }

    public boolean hasNextShort(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isShortValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, DataType.INT);
            try {
                this.cacheHasNextValue = Short.valueOf(intString, radix);
                isShortValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isShortValue;
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public Locale locale() {
        return this.locale;
    }

    public MatchResult match() {
        if (!this.matchSuccessful) {
            throw new IllegalStateException();
        }
        return this.matcher.toMatchResult();
    }

    @Override
    public String next() {
        return this.next(ANY_PATTERN);
    }

    public String next(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        this.matchSuccessful = false;
        this.saveCurrentStatus();
        if (!this.setTokenRegion()) {
            this.recoverPreviousStatus();
            throw new NoSuchElementException();
        }
        this.matcher.usePattern(pattern);
        if (!this.matcher.matches()) {
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        this.matchSuccessful = true;
        return this.matcher.group();
    }

    public String next(String pattern) {
        return this.next(Pattern.compile(pattern));
    }

    public BigDecimal nextBigDecimal() {
        BigDecimal bigDecimalValue;
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof BigDecimal) {
            this.findStartIndex = this.cachehasNextIndex;
            return (BigDecimal)obj;
        }
        Pattern floatPattern = this.getFloatPattern();
        String floatString = this.next(floatPattern);
        floatString = this.removeLocaleInfoFromFloat(floatString);
        try {
            bigDecimalValue = new BigDecimal(floatString);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return bigDecimalValue;
    }

    public BigInteger nextBigInteger() {
        return this.nextBigInteger(this.integerRadix);
    }

    public BigInteger nextBigInteger(int radix) {
        BigInteger bigIntegerValue;
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof BigInteger) {
            this.findStartIndex = this.cachehasNextIndex;
            return (BigInteger)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, DataType.INT);
        try {
            bigIntegerValue = new BigInteger(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return bigIntegerValue;
    }

    public boolean nextBoolean() {
        return Boolean.parseBoolean(this.next(BOOLEAN_PATTERN));
    }

    public byte nextByte() {
        return this.nextByte(this.integerRadix);
    }

    public byte nextByte(int radix) {
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof Byte) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Byte)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, DataType.INT);
        byte byteValue = 0;
        try {
            byteValue = Byte.parseByte(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return byteValue;
    }

    public double nextDouble() {
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof Double) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Double)obj;
        }
        Pattern floatPattern = this.getFloatPattern();
        String floatString = this.next(floatPattern);
        floatString = this.removeLocaleInfoFromFloat(floatString);
        double doubleValue = 0.0;
        try {
            doubleValue = Double.parseDouble(floatString);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return doubleValue;
    }

    public float nextFloat() {
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof Float) {
            this.findStartIndex = this.cachehasNextIndex;
            return ((Float)obj).floatValue();
        }
        Pattern floatPattern = this.getFloatPattern();
        String floatString = this.next(floatPattern);
        floatString = this.removeLocaleInfoFromFloat(floatString);
        float floatValue = 0.0f;
        try {
            floatValue = Float.parseFloat(floatString);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return floatValue;
    }

    public int nextInt() {
        return this.nextInt(this.integerRadix);
    }

    public int nextInt(int radix) {
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof Integer) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Integer)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, DataType.INT);
        int intValue = 0;
        try {
            intValue = Integer.parseInt(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return intValue;
    }

    public String nextLine() {
        Matcher terminatorMatcher;
        this.checkClosed();
        this.matcher.usePattern(LINE_PATTERN);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        String result = null;
        while (true) {
            if (this.matcher.find()) {
                if (this.inputExhausted || this.matcher.end() != this.bufferLength || this.bufferLength < this.buffer.capacity()) {
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                throw new NoSuchElementException();
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        this.matchSuccessful = true;
        this.findStartIndex = this.matcher.end();
        result = this.matcher.group();
        if (result != null && (terminatorMatcher = LINE_TERMINATOR.matcher(result)).find()) {
            result = result.substring(0, terminatorMatcher.start());
        }
        return result;
    }

    public long nextLong() {
        return this.nextLong(this.integerRadix);
    }

    public long nextLong(int radix) {
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof Long) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Long)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, DataType.INT);
        long longValue = 0L;
        try {
            longValue = Long.parseLong(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return longValue;
    }

    public short nextShort() {
        return this.nextShort(this.integerRadix);
    }

    public short nextShort(int radix) {
        this.checkClosed();
        Object obj = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (obj instanceof Short) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Short)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, DataType.INT);
        short shortValue = 0;
        try {
            shortValue = Short.parseShort(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return shortValue;
    }

    public int radix() {
        return this.integerRadix;
    }

    public Scanner skip(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        this.matcher.usePattern(pattern);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        while (true) {
            if (this.matcher.lookingAt()) {
                boolean matchInBuffer;
                boolean bl = matchInBuffer = this.matcher.end() < this.bufferLength || this.matcher.end() == this.bufferLength && this.inputExhausted;
                if (matchInBuffer) {
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                throw new NoSuchElementException();
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        this.matchSuccessful = true;
        this.findStartIndex = this.matcher.end();
        return this;
    }

    public Scanner skip(String pattern) {
        return this.skip(Pattern.compile(pattern));
    }

    public String toString() {
        return this.getClass().getName() + "[delimiter=" + this.delimiter + ",findStartIndex=" + this.findStartIndex + ",matchSuccessful=" + this.matchSuccessful + ",closed=" + this.closed + "]";
    }

    public Scanner useDelimiter(Pattern pattern) {
        this.delimiter = pattern;
        return this;
    }

    public Scanner useDelimiter(String pattern) {
        return this.useDelimiter(Pattern.compile(pattern));
    }

    public Scanner useLocale(Locale l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this.locale = l;
        return this;
    }

    public Scanner useRadix(int radix) {
        this.checkRadix(radix);
        this.integerRadix = radix;
        return this;
    }

    private void checkRadix(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Invalid radix: " + radix);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initialization() {
        this.buffer = CharBuffer.allocate(1024);
        this.buffer.limit(0);
        this.matcher = this.delimiter.matcher(this.buffer);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    private void checkNull(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
    }

    private void resetMatcher() {
        if (this.matcher == null) {
            this.matcher = this.delimiter.matcher(this.buffer);
        } else {
            this.matcher.reset(this.buffer);
        }
        this.matcher.region(this.findStartIndex, this.bufferLength);
    }

    private void saveCurrentStatus() {
        this.preStartIndex = this.findStartIndex;
    }

    private void recoverPreviousStatus() {
        this.findStartIndex = this.preStartIndex;
    }

    private Pattern getIntegerPattern(int radix) {
        this.checkRadix(radix);
        this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
        String allAvailableDigits = "0123456789abcdefghijklmnopqrstuvwxyz";
        String ASCIIDigit = allAvailableDigits.substring(0, radix);
        String nonZeroASCIIDigit = allAvailableDigits.substring(1, radix);
        StringBuilder digit = new StringBuilder("((?i)[").append(ASCIIDigit).append("]|\\p{javaDigit})");
        StringBuilder nonZeroDigit = new StringBuilder("((?i)[").append(nonZeroASCIIDigit).append("]|([\\p{javaDigit}&&[^0]]))");
        StringBuilder numeral = this.getNumeral(digit, nonZeroDigit);
        StringBuilder integer = new StringBuilder("(([-+]?(").append(numeral).append(")))|(").append(this.addPositiveSign(numeral)).append(")|(").append(this.addNegativeSign(numeral)).append(")");
        Pattern integerPattern = Pattern.compile(integer.toString());
        return integerPattern;
    }

    private Pattern getFloatPattern() {
        this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
        StringBuilder digit = new StringBuilder("([0-9]|(\\p{javaDigit}))");
        StringBuilder nonZeroDigit = new StringBuilder("[\\p{javaDigit}&&[^0]]");
        StringBuilder numeral = this.getNumeral(digit, nonZeroDigit);
        String decimalSeparator = "\\" + this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        StringBuilder decimalNumeral = new StringBuilder("(").append(numeral).append("|").append(numeral).append(decimalSeparator).append(digit).append("*+|").append(decimalSeparator).append(digit).append("++)");
        StringBuilder exponent = new StringBuilder("([eE][+-]?").append(digit).append("+)?");
        StringBuilder decimal = new StringBuilder("(([-+]?").append(decimalNumeral).append("(").append(exponent).append("?)").append(")|(").append(this.addPositiveSign(decimalNumeral)).append("(").append(exponent).append("?)").append(")|(").append(this.addNegativeSign(decimalNumeral)).append("(").append(exponent).append("?)").append("))");
        StringBuilder hexFloat = new StringBuilder("([-+]?0[xX][0-9a-fA-F]*").append("\\.").append("[0-9a-fA-F]+([pP][-+]?[0-9]+)?)");
        String localNaN = this.decimalFormat.getDecimalFormatSymbols().getNaN();
        String localeInfinity = this.decimalFormat.getDecimalFormatSymbols().getInfinity();
        StringBuilder nonNumber = new StringBuilder("(NaN|\\Q").append(localNaN).append("\\E|Infinity|\\Q").append(localeInfinity).append("\\E)");
        StringBuilder singedNonNumber = new StringBuilder("((([-+]?(").append(nonNumber).append(")))|(").append(this.addPositiveSign(nonNumber)).append(")|(").append(this.addNegativeSign(nonNumber)).append("))");
        StringBuilder floatString = new StringBuilder().append(decimal).append("|").append(hexFloat).append("|").append(singedNonNumber);
        Pattern floatPattern = Pattern.compile(floatString.toString());
        return floatPattern;
    }

    private StringBuilder getNumeral(StringBuilder digit, StringBuilder nonZeroDigit) {
        String groupSeparator = "\\" + this.decimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
        StringBuilder groupedNumeral = new StringBuilder("(").append(nonZeroDigit).append(digit).append("?").append(digit).append("?(").append(groupSeparator).append(digit).append(digit).append(digit).append(")+)");
        StringBuilder numeral = new StringBuilder("((").append(digit).append("++)|").append(groupedNumeral).append(")");
        return numeral;
    }

    private StringBuilder addPositiveSign(StringBuilder unSignNumeral) {
        String positivePrefix = "";
        String positiveSuffix = "";
        if (!this.decimalFormat.getPositivePrefix().isEmpty()) {
            positivePrefix = "\\Q" + this.decimalFormat.getPositivePrefix() + "\\E";
        }
        if (!this.decimalFormat.getPositiveSuffix().isEmpty()) {
            positiveSuffix = "\\Q" + this.decimalFormat.getPositiveSuffix() + "\\E";
        }
        StringBuilder signedNumeral = new StringBuilder().append(positivePrefix).append(unSignNumeral).append(positiveSuffix);
        return signedNumeral;
    }

    private StringBuilder addNegativeSign(StringBuilder unSignNumeral) {
        String negativePrefix = "";
        String negativeSuffix = "";
        if (!this.decimalFormat.getNegativePrefix().isEmpty()) {
            negativePrefix = "\\Q" + this.decimalFormat.getNegativePrefix() + "\\E";
        }
        if (!this.decimalFormat.getNegativeSuffix().isEmpty()) {
            negativeSuffix = "\\Q" + this.decimalFormat.getNegativeSuffix() + "\\E";
        }
        StringBuilder signedNumeral = new StringBuilder().append(negativePrefix).append(unSignNumeral).append(negativeSuffix);
        return signedNumeral;
    }

    private String removeLocaleInfoFromFloat(String floatString) {
        if (-1 != floatString.indexOf(120) || -1 != floatString.indexOf(88)) {
            return floatString;
        }
        int exponentIndex = floatString.indexOf(101);
        if (-1 != exponentIndex || -1 != (exponentIndex = floatString.indexOf(69))) {
            String decimalNumeralString = floatString.substring(0, exponentIndex);
            String exponentString = floatString.substring(exponentIndex + 1, floatString.length());
            decimalNumeralString = this.removeLocaleInfo(decimalNumeralString, DataType.FLOAT);
            return decimalNumeralString + "e" + exponentString;
        }
        return this.removeLocaleInfo(floatString, DataType.FLOAT);
    }

    private String removeLocaleInfo(String token, DataType type) {
        int i;
        StringBuilder tokenBuilder = new StringBuilder(token);
        boolean negative = this.removeLocaleSign(tokenBuilder);
        String groupSeparator = String.valueOf(this.decimalFormat.getDecimalFormatSymbols().getGroupingSeparator());
        int separatorIndex = -1;
        while (-1 != (separatorIndex = tokenBuilder.indexOf(groupSeparator))) {
            tokenBuilder.delete(separatorIndex, separatorIndex + 1);
        }
        String decimalSeparator = String.valueOf(this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
        separatorIndex = tokenBuilder.indexOf(decimalSeparator);
        StringBuilder result = new StringBuilder("");
        if (DataType.INT == type) {
            for (i = 0; i < tokenBuilder.length(); ++i) {
                if (-1 == Character.digit(tokenBuilder.charAt(i), 36)) continue;
                result.append(tokenBuilder.charAt(i));
            }
        }
        if (DataType.FLOAT == type) {
            if (tokenBuilder.toString().equals(this.decimalFormat.getDecimalFormatSymbols().getNaN())) {
                result.append("NaN");
            } else if (tokenBuilder.toString().equals(this.decimalFormat.getDecimalFormatSymbols().getInfinity())) {
                result.append("Infinity");
            } else {
                for (i = 0; i < tokenBuilder.length(); ++i) {
                    if (-1 == Character.digit(tokenBuilder.charAt(i), 10)) continue;
                    result.append(Character.digit(tokenBuilder.charAt(i), 10));
                }
            }
        }
        if (result.length() == 0) {
            result = tokenBuilder;
        }
        if (-1 != separatorIndex) {
            result.insert(separatorIndex, ".");
        }
        if (negative) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    private boolean removeLocaleSign(StringBuilder tokenBuilder) {
        String positivePrefix = this.decimalFormat.getPositivePrefix();
        String positiveSuffix = this.decimalFormat.getPositiveSuffix();
        String negativePrefix = this.decimalFormat.getNegativePrefix();
        String negativeSuffix = this.decimalFormat.getNegativeSuffix();
        if (tokenBuilder.indexOf("+") == 0) {
            tokenBuilder.delete(0, 1);
        }
        if (!positivePrefix.isEmpty() && tokenBuilder.indexOf(positivePrefix) == 0) {
            tokenBuilder.delete(0, positivePrefix.length());
        }
        if (!positiveSuffix.isEmpty() && -1 != tokenBuilder.indexOf(positiveSuffix)) {
            tokenBuilder.delete(tokenBuilder.length() - positiveSuffix.length(), tokenBuilder.length());
        }
        boolean negative = false;
        if (tokenBuilder.indexOf("-") == 0) {
            tokenBuilder.delete(0, 1);
            negative = true;
        }
        if (!negativePrefix.isEmpty() && tokenBuilder.indexOf(negativePrefix) == 0) {
            tokenBuilder.delete(0, negativePrefix.length());
            negative = true;
        }
        if (!negativeSuffix.isEmpty() && -1 != tokenBuilder.indexOf(negativeSuffix)) {
            tokenBuilder.delete(tokenBuilder.length() - negativeSuffix.length(), tokenBuilder.length());
            negative = true;
        }
        return negative;
    }

    private boolean setTokenRegion() {
        int tokenStartIndex = 0;
        int tokenEndIndex = 0;
        this.matcher.usePattern(this.delimiter);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        tokenStartIndex = this.findPreDelimiter();
        if (this.setHeadTokenRegion(tokenStartIndex)) {
            return true;
        }
        tokenEndIndex = this.findPostDelimiter();
        if (-1 == tokenEndIndex) {
            if (this.findStartIndex == this.bufferLength) {
                return false;
            }
            tokenEndIndex = this.bufferLength;
            this.findStartIndex = this.bufferLength;
        }
        this.matcher.region(tokenStartIndex, tokenEndIndex);
        return true;
    }

    private int findPreDelimiter() {
        boolean findComplete = false;
        while (!findComplete) {
            if (this.matcher.find()) {
                findComplete = true;
                if (this.matcher.start() != this.findStartIndex || this.matcher.end() != this.bufferLength || this.inputExhausted) continue;
                this.readMore();
                this.resetMatcher();
                findComplete = false;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            return -1;
        }
        int tokenStartIndex = this.matcher.end();
        this.findStartIndex = this.matcher.end();
        return tokenStartIndex;
    }

    private boolean setHeadTokenRegion(int findIndex) {
        int tokenEndIndex;
        int tokenStartIndex;
        boolean setSuccess = false;
        if (-1 == findIndex && this.preStartIndex != this.bufferLength) {
            tokenStartIndex = this.preStartIndex;
            tokenEndIndex = this.bufferLength;
            this.findStartIndex = this.bufferLength;
            this.matcher.region(tokenStartIndex, tokenEndIndex);
            setSuccess = true;
        }
        if (-1 != findIndex && this.preStartIndex != this.matcher.start()) {
            tokenStartIndex = this.preStartIndex;
            tokenEndIndex = this.matcher.start();
            this.findStartIndex = this.matcher.start();
            this.matcher.region(tokenStartIndex, tokenEndIndex);
            setSuccess = true;
        }
        return setSuccess;
    }

    private int findPostDelimiter() {
        int tokenEndIndex = 0;
        boolean findComplete = false;
        while (!findComplete) {
            if (this.matcher.find()) {
                findComplete = true;
                if (this.matcher.start() != this.findStartIndex || this.matcher.start() != this.matcher.end()) continue;
                findComplete = false;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            return -1;
        }
        tokenEndIndex = this.matcher.start();
        this.findStartIndex = this.matcher.start();
        return tokenEndIndex;
    }

    private void readMore() {
        int oldPosition = this.buffer.position();
        int oldBufferLength = this.bufferLength;
        if (this.bufferLength >= this.buffer.capacity()) {
            this.expandBuffer();
        }
        int readCount = 0;
        try {
            this.buffer.limit(this.buffer.capacity());
            this.buffer.position(oldBufferLength);
            while ((readCount = this.input.read(this.buffer)) == 0) {
            }
        }
        catch (IOException e) {
            this.bufferLength = this.buffer.position();
            readCount = -1;
            this.lastIOException = e;
        }
        this.buffer.flip();
        this.buffer.position(oldPosition);
        if (-1 == readCount) {
            this.inputExhausted = true;
        } else {
            this.bufferLength = readCount + this.bufferLength;
        }
    }

    private void expandBuffer() {
        int oldPosition = this.buffer.position();
        int oldCapacity = this.buffer.capacity();
        int oldLimit = this.buffer.limit();
        int newCapacity = oldCapacity * 2;
        char[] newBuffer = new char[newCapacity];
        System.arraycopy(this.buffer.array(), 0, newBuffer, 0, oldLimit);
        this.buffer = CharBuffer.wrap(newBuffer, 0, newCapacity);
        this.buffer.position(oldPosition);
        this.buffer.limit(oldLimit);
    }

    public Scanner reset() {
        this.delimiter = DEFAULT_DELIMITER;
        this.locale = Locale.getDefault();
        this.integerRadix = 10;
        return this;
    }

    static {
        String NL = "\n|\r\n|\r|\u0085|\u2028|\u2029";
        LINE_TERMINATOR = Pattern.compile(NL);
        MULTI_LINE_TERMINATOR = Pattern.compile("(" + NL + ")+");
        LINE_PATTERN = Pattern.compile(".*(" + NL + ")|.+(" + NL + ")?");
        ANY_PATTERN = Pattern.compile("(?s).*");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DataType {
        INT,
        FLOAT;

    }
}

