/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import libcore.icu.TimeZones;
import libcore.util.ZoneInfoDB;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3581463369166924961L;
    public static final int SHORT = 0;
    public static final int LONG = 1;
    static final TimeZone GMT = new SimpleTimeZone(0, "GMT");
    private static TimeZone defaultTimeZone;
    private String ID;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfoDB.getAvailableIDs();
    }

    public static synchronized String[] getAvailableIDs(int offsetMillis) {
        return ZoneInfoDB.getAvailableIDs(offsetMillis);
    }

    public static synchronized TimeZone getDefault() {
        if (defaultTimeZone == null) {
            defaultTimeZone = ZoneInfoDB.getSystemDefault();
        }
        return (TimeZone)defaultTimeZone.clone();
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean daylightTime, int style) {
        return this.getDisplayName(daylightTime, style, Locale.getDefault());
    }

    public String getDisplayName(boolean daylightTime, int style, Locale locale) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException();
        }
        boolean useDaylight = daylightTime && this.useDaylightTime();
        String[][] zoneStrings = TimeZones.getZoneStrings(locale);
        String result = TimeZones.getDisplayName(zoneStrings, this.getID(), daylightTime, style);
        if (result != null) {
            return result;
        }
        int offset = this.getRawOffset();
        if (useDaylight && this instanceof SimpleTimeZone) {
            offset += this.getDSTSavings();
        }
        char sign = '+';
        if ((offset /= 60000) < 0) {
            sign = '-';
            offset = -offset;
        }
        StringBuilder builder = new StringBuilder(9);
        builder.append("GMT");
        builder.append(sign);
        this.appendNumber(builder, 2, offset / 60);
        builder.append(':');
        this.appendNumber(builder, 2, offset % 60);
        return builder.toString();
    }

    private void appendNumber(StringBuilder builder, int count, int value) {
        String string = Integer.toString(value);
        for (int i = 0; i < count - string.length(); ++i) {
            builder.append('0');
        }
        builder.append(string);
    }

    public String getID() {
        return this.ID;
    }

    public int getDSTSavings() {
        return this.useDaylightTime() ? 3600000 : 0;
    }

    public int getOffset(long time) {
        if (this.inDaylightTime(new Date(time))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getRawOffset();

    public static synchronized TimeZone getTimeZone(String id) {
        TimeZone zone = ZoneInfoDB.getTimeZone(id);
        if (zone != null) {
            return zone;
        }
        if (zone == null && id.length() > 3 && id.startsWith("GMT")) {
            zone = TimeZone.getCustomTimeZone(id);
        }
        if (zone == null) {
            zone = (TimeZone)GMT.clone();
        }
        return zone;
    }

    private static TimeZone getCustomTimeZone(String id) {
        char sign = id.charAt(3);
        if (sign != '+' && sign != '-') {
            return null;
        }
        int[] position = new int[1];
        String formattedName = TimeZone.formatTimeZoneName(id, 4);
        int hour = TimeZone.parseNumber(formattedName, 4, position);
        if (hour < 0 || hour > 23) {
            return null;
        }
        int index = position[0];
        if (index == -1) {
            return null;
        }
        int raw = hour * 3600000;
        if (index < formattedName.length() && formattedName.charAt(index) == ':') {
            int minute = TimeZone.parseNumber(formattedName, index + 1, position);
            if (position[0] == -1 || minute < 0 || minute > 59) {
                return null;
            }
            raw += minute * 60000;
        } else if (hour >= 30 || index > 6) {
            raw = hour / 100 * 3600000 + hour % 100 * 60000;
        }
        if (sign == '-') {
            raw = -raw;
        }
        return new SimpleTimeZone(raw, formattedName);
    }

    private static String formatTimeZoneName(String name, int offset) {
        StringBuilder buf = new StringBuilder();
        int length = name.length();
        buf.append(name.substring(0, offset));
        for (int index = offset; index < length; ++index) {
            if (Character.digit(name.charAt(index), 10) != -1) {
                buf.append(name.charAt(index));
                if (length - (index + 1) != 2) continue;
                buf.append(':');
                continue;
            }
            if (name.charAt(index) != ':') continue;
            buf.append(':');
        }
        if (buf.toString().indexOf(":") == -1) {
            buf.append(':');
            buf.append("00");
        }
        if (buf.toString().indexOf(":") == 5) {
            buf.insert(4, '0');
        }
        return buf.toString();
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (timeZone == null) {
            return false;
        }
        return this.getRawOffset() == timeZone.getRawOffset();
    }

    public abstract boolean inDaylightTime(Date var1);

    private static int parseNumber(String string, int offset, int[] position) {
        int digit;
        int index;
        int length = string.length();
        int result = 0;
        for (index = offset; index < length && (digit = Character.digit(string.charAt(index), 10)) != -1; ++index) {
            result = result * 10 + digit;
        }
        position[0] = index == offset ? -1 : index;
        return result;
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultTimeZone = timeZone != null ? (TimeZone)timeZone.clone() : null;
    }

    public void setID(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this.ID = id;
    }

    public abstract void setRawOffset(int var1);

    public abstract boolean useDaylightTime();
}

