/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import dalvik.system.VMStack;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.UnsafeAccess;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicIntegerFieldUpdater<T> {
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> tclass, String fieldName) {
        return new AtomicIntegerFieldUpdaterImpl<U>(tclass, fieldName);
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract void lazySet(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T obj, int newValue) {
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), newValue)) {
        }
        return current;
    }

    public int getAndIncrement(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1)) {
        }
        return current;
    }

    public int getAndDecrement(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1)) {
        }
        return current;
    }

    public int getAndAdd(T obj, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return current;
    }

    public int incrementAndGet(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + 1)) {
        }
        return next;
    }

    public int decrementAndGet(T obj) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current - 1)) {
        }
        return next;
    }

    public int addAndGet(T obj, int delta) {
        int next;
        int current;
        while (!this.compareAndSet(obj, current = this.get(obj), next = current + delta)) {
        }
        return next;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private static final Unsafe unsafe = UnsafeAccess.THE_ONE;
        private final long offset;
        private final Class<T> tclass;
        private final Class cclass;

        AtomicIntegerFieldUpdaterImpl(Class<T> tclass, String fieldName) {
            Field field = null;
            Class<?> caller = null;
            int modifiers = 0;
            try {
                field = tclass.getDeclaredField(fieldName);
                caller = VMStack.getStackClass2();
                modifiers = field.getModifiers();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Class<?> fieldt = field.getType();
            if (fieldt != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && caller != tclass ? caller : null;
            this.tclass = tclass;
            this.offset = unsafe.objectFieldOffset(field);
        }

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        @Override
        public boolean compareAndSet(T obj, int expect, int update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return unsafe.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, int expect, int update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return unsafe.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            unsafe.putIntVolatile(obj, this.offset, newValue);
        }

        @Override
        public void lazySet(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            unsafe.putOrderedInt(obj, this.offset, newValue);
        }

        @Override
        public final int get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return unsafe.getIntVolatile(obj, this.offset);
        }

        private void ensureProtectedAccess(T obj) {
            if (this.cclass.isInstance(obj)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }
    }
}

