/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.UnsafeAccess;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe = UnsafeAccess.THE_ONE;
    private static final int base = unsafe.arrayBaseOffset(Object[].class);
    private static final int shift;
    private final Object[] array;

    private long checkedByteOffset(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return AtomicReferenceArray.byteOffset(i);
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    public AtomicReferenceArray(int length) {
        this.array = new Object[length];
    }

    public AtomicReferenceArray(E[] array) {
        this.array = (Object[])array.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int i) {
        return this.getRaw(this.checkedByteOffset(i));
    }

    private E getRaw(long offset) {
        return (E)unsafe.getObjectVolatile(this.array, offset);
    }

    public final void set(int i, E newValue) {
        unsafe.putObjectVolatile(this.array, this.checkedByteOffset(i), newValue);
    }

    public final void lazySet(int i, E newValue) {
        unsafe.putOrderedObject(this.array, this.checkedByteOffset(i), newValue);
    }

    public final E getAndSet(int i, E newValue) {
        E current;
        long offset = this.checkedByteOffset(i);
        while (!this.compareAndSetRaw(offset, current = this.getRaw(offset), newValue)) {
        }
        return current;
    }

    public final boolean compareAndSet(int i, E expect, E update) {
        return this.compareAndSetRaw(this.checkedByteOffset(i), expect, update);
    }

    private boolean compareAndSetRaw(long offset, E expect, E update) {
        return unsafe.compareAndSwapObject(this.array, offset, expect, update);
    }

    public final boolean weakCompareAndSet(int i, E expect, E update) {
        return this.compareAndSet(i, expect, update);
    }

    public String toString() {
        int iMax = this.array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.getRaw(AtomicReferenceArray.byteOffset(i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }

    static {
        int scale = unsafe.arrayIndexScale(Object[].class);
        if ((scale & scale - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        shift = 31 - Integer.numberOfLeadingZeros(scale);
    }
}

